"use strict";async function getTokenContractAddress(e,r){try{const t=await getEcosystemToken(e,r);if(!t)throw(0,error_1.createError)({statusCode:404,message:`No token found for chain "${e}" and currency "${r}".`});const o=t.contract;if(!ethers_1.ethers.isAddress(o))throw(0,error_1.createError)({statusCode:400,message:`The token contract address "${o}" is invalid.`});return{contractAddress:o,contractType:t.contractType,tokenDecimals:t.decimals}}catch(t){console_1.logger.error("TOKEN_CONTRACT",`Unable to retrieve token contract details for chain "${e}" and currency "${r}"`,t);throw(0,error_1.createError)({statusCode:t.statusCode||500,message:`Unable to retrieve token contract details for chain "${e}" and currency "${r}". ${t.message||"Please try again later."}`})}}async function deployTokenContract(e,r,t,o,s,a,n,c){var i,d;try{const l=await(0,provider_1.getProvider)(r);if(!l)throw(0,error_1.createError)({statusCode:500,message:"Provider not initialized"});if(!e.data)throw(0,error_1.createError)({statusCode:404,message:"Master wallet data not found"});const h=JSON.parse((0,encrypt_1.decrypt)(e.data));if(!h||!h.privateKey)throw(0,error_1.createError)({statusCode:500,message:"Decrypted data or Mnemonic not found"});const{privateKey:u}=h,_=new ethers_1.ethers.Wallet(u).connect(l),g=null===(d=null===(i=chains_1.chainConfigs[r])||void 0===i?void 0:i.smartContract)||void 0===d?void 0:d.file;if(!g)throw(0,error_1.createError)({statusCode:404,message:`Smart contract file not found for chain ${r}`});const{abi:f,bytecode:p}=await(0,smartContract_1.getSmartContract)("token",g);if(!f||!p)throw(0,error_1.createError)({statusCode:500,message:"Smart contract ABI or Bytecode not found"});const C=new ethers_1.ContractFactory(f,p,_);if(void 0===n||void 0===c)throw(0,error_1.createError)({statusCode:400,message:"Initial balance or Cap is undefined"});const E=ethers_1.ethers.parseUnits(n.toString(),a),m=ethers_1.ethers.parseUnits(c.toString(),a),w=await(0,gas_1.getAdjustedGasPrice)(l),y=await C.deploy(t,o,s,a,m,E,{gasPrice:w}),k=await y.waitForDeployment();return await k.getAddress()}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Failed to deploy token contract on chain "${r}". ${e.message||"An unknown error occurred."}`})}}async function getEcosystemToken(e,r){const t={chain:e,currency:r,status:!0};if(!["XMR","TON","SOL","TRON","BTC","LTC","DOGE","DASH"].includes(e)){const r=process.env[`${e}_NETWORK`];r&&(t.network=r)}const o=await db_1.models.ecosystemToken.findOne({where:t});if(!o)throw(0,error_1.createError)({statusCode:404,message:`Token not found for chain: ${e} and currency: ${r}`});return o}Object.defineProperty(exports,"__esModule",{value:!0});exports.fetchTokenHolders=void 0;exports.getTokenContractAddress=getTokenContractAddress;exports.deployTokenContract=deployTokenContract;exports.getEcosystemToken=getEcosystemToken;const ethers_1=require("ethers"),chains_1=require("./chains"),redis_1=require("../../../../utils/redis"),gas_1=require("./gas"),smartContract_1=require("./smartContract"),encrypt_1=require("../../../../utils/encrypt"),provider_1=require("./provider"),db_1=require("@b/db"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),CACHE_EXPIRATION=300,fetchTokenHolders=async(e,r,t)=>{try{const o=chains_1.chainConfigs[e];if(!o)throw(0,error_1.createError)({statusCode:400,message:`Chain "${e}" is not supported.`});const s=process.env.ETHERSCAN_API_KEY||process.env[`${e}_EXPLORER_API_KEY`];if(!s)throw(0,error_1.createError)({statusCode:500,message:`ETHERSCAN_API_KEY or ${e}_EXPLORER_API_KEY is not configured.`});const a=o.networks[r];if(!a||!a.explorer)throw(0,error_1.createError)({statusCode:400,message:`Network "${r}" for chain "${e}" is not supported.`});const n=`token:${t}:holders`,c=await getCachedData(n);if(c)return c;if(!a.chainId)throw(0,error_1.createError)({statusCode:500,message:`Chain ID not configured for network "${r}" on chain "${e}". V2 API requires chainId.`});const i=`https://api.etherscan.io/v2/api?chainid=${a.chainId}&module=account&action=tokentx&contractaddress=${t}&page=1&offset=100&sort=asc&apikey=${s}`;let d;try{const e=await fetch(i);d=await e.json()}catch(e){console_1.logger.error("TOKEN_HOLDERS","Failed to fetch token holders",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch token holders. Please check the API connection."})}if("0"===d.status&&"NOTOK"===d.message){console_1.logger.warn("TOKEN_HOLDERS",`Etherscan API error for token holders of contract ${t}: ${d.result}`);return{}}if("1"!==d.status)throw(0,error_1.createError)({statusCode:502,message:`Explorer API returned error: ${d.message}`});const l={};for(const e of d.result){const{from:r,to:t,value:o}=e;l[r]=(l[r]||0)-parseFloat(o);l[t]=(l[t]||0)+parseFloat(o)}const h=o.decimals||18,u=Object.entries(l).map(([e,r])=>({address:e,balance:parseFloat((r/Math.pow(10,h)).toFixed(8))})).filter(e=>e.balance>0),_=redis_1.RedisSingleton.getInstance();await _.setex(n,300,JSON.stringify(u));return u}catch(r){console_1.logger.error("TOKEN_HOLDERS",`Failed to fetch token holders for contract "${t}" on chain "${e}"`,r);throw(0,error_1.createError)({statusCode:r.statusCode||500,message:`Failed to fetch token holders for contract "${t}" on chain "${e}". ${r.message||"Please try again later."}`})}};exports.fetchTokenHolders=fetchTokenHolders;const getCachedData=async e=>{const r=redis_1.RedisSingleton.getInstance(),t=await r.get(e);return t?JSON.parse(t):null};