"use strict";function getToleranceDigits(e){return 18-e}async function getSymbolDecimals(e){var r;const[t,a]=e.split("/");if(tokenDecimalsCache.has(e))return tokenDecimalsCache.get(e);try{const{models:o}=await Promise.resolve().then(()=>__importStar(require("@b/db"))),s=await o.ecosystemMarket.findOne({where:{currency:t,pair:a},attributes:["metadata"]});if(s){const t=s.metadata;if(void 0!==(null===(r=null==t?void 0:t.precision)||void 0===r?void 0:r.amount)){const r=Number(t.precision.amount);tokenDecimalsCache.set(e,r);return r}}const n=["ETH","BSC","MATIC","BTC","SOL"];for(const r of n)try{const a=await(0,tokens_1.getEcosystemToken)(r,t);if(a&&void 0!==a.decimals){tokenDecimalsCache.set(e,a.decimals);return a.decimals}}catch(e){continue}console_1.logger.warn("SCYLLA",`Could not find decimals for ${e}, defaulting to 8`);tokenDecimalsCache.set(e,8);return 8}catch(r){console_1.logger.error("SCYLLA",`Error fetching decimals for ${e}`,r);return 8}}async function query(e,r=[]){return client_1.default.execute(e,r,{prepare:!0})}async function getOrdersByUserId(e){const r=`\n    SELECT * FROM ${scyllaKeyspace}.orders\n    WHERE "userId" = ?\n    ORDER BY "createdAt" DESC;\n  `,t=[e];try{const e=await client_1.default.execute(r,t,{prepare:!0});return e.rows.map(mapRowToOrder)}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch orders by userId: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch orders by userId: ${e.message}`})}}function mapRowToOrder(e){return{id:e.id,userId:e.userId,symbol:e.symbol,type:e.type,side:e.side,price:e.price,amount:e.amount,filled:e.filled,remaining:e.remaining,timeInForce:e.timeInForce,cost:e.cost,fee:e.fee,feeCurrency:e.feeCurrency,average:e.average,trades:e.trades,status:e.status,createdAt:e.createdAt,updatedAt:e.updatedAt,marketMakerId:e.marketMakerId,botId:e.botId,walletType:e.walletType||"ECO"}}function getOrderByUuid(e,r,t){const a=`\n    SELECT * FROM ${scyllaKeyspace}.orders\n    WHERE "userId" = ? AND id = ? AND "createdAt" = ?;\n  `,o=[e,r,t];return client_1.default.execute(a,o,{prepare:!0}).then(e=>e.rows[0]).then(mapRowToOrder)}async function cancelOrderByUuid(e,r,t,a,o,s,n){const c=`\n    SELECT id, symbol, status FROM ${scyllaKeyspace}.orders\n    WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n  `,i=[e,new Date(t),r];try{const a=await client_1.default.execute(c,i,{prepare:!0});if(0===a.rows.length){console_1.logger.debug("SCYLLA",`Order ${r} not found for user ${e} at ${t} - skipping cancellation (likely already filled)`);return}const o=a.rows[0];if("CANCELED"===o.status||"CLOSED"===o.status){console_1.logger.debug("SCYLLA",`Order ${r} is already ${o.status} - skipping`);return}}catch(e){console_1.logger.error("SCYLLA",`Failed to check order existence: ${e.message}`,e);throw e}const l=(0,blockchain_1.fromBigInt)(o),d="BUY"===s?"BIDS":"ASKS",u=await getOrderbookEntry(a,l,d);let p="",m=[];if(u){const e=u-n;if(e<=BigInt(0)){p=`DELETE FROM ${scyllaKeyspace}.orderbook WHERE symbol = ? AND price = ? AND side = ?`;m=[a,l.toString(),d]}else{p=`UPDATE ${scyllaKeyspace}.orderbook SET amount = ? WHERE symbol = ? AND price = ? AND side = ?`;m=[(0,blockchain_1.fromBigInt)(e).toString(),a,l.toString(),d]}}else"development"===process.env.NODE_ENV&&console_1.logger.debug("SCYLLA",`No orderbook entry found for symbol: ${a}, price: ${l}, side: ${d}`);const g=new Date,y=`\n    UPDATE ${scyllaKeyspace}.orders\n    SET status = 'CANCELED', "updatedAt" = ?\n    WHERE "userId" = ? AND id = ? AND "createdAt" = ?;\n  `,f=[g,e,r,new Date(t)],E=p?[{query:p,params:m},{query:y,params:f}]:[{query:y,params:f}];try{await client_1.default.batch(E,{prepare:!0})}catch(e){console_1.logger.error("SCYLLA",`Failed to cancel order and update orderbook: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to cancel order and update orderbook: ${e.message}`})}}async function getOrderbookEntry(e,r,t){const a=`\n    SELECT * FROM ${scyllaKeyspace}.orderbook\n    WHERE symbol = ? AND price = ? AND side = ?;\n  `,o=[e,r,t];try{const e=await client_1.default.execute(a,o,{prepare:!0});if(e.rows.length>0){const r=e.rows[0];return(0,blockchain_1.toBigIntFloat)(r.amount)}return null}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch orderbook entry: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch orderbook entry: ${e.message}`})}}async function createOrder({userId:e,symbol:r,amount:t,price:a,cost:o,type:s,side:n,fee:c,feeCurrency:i,marketMakerId:l,botId:d,walletType:u="ECO"}){if(!e||"string"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: userId is required and must be a valid string"});if(!r||"string"!=typeof r)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: symbol is required and must be a valid string"});if(!s||"string"!=typeof s)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: type is required and must be a valid string"});if(!n||"string"!=typeof n)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: side is required and must be a valid string"});if(!i||"string"!=typeof i)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: feeCurrency is required and must be a valid string"});if("bigint"!=typeof a)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: price is required and must be a bigint"});if("bigint"!=typeof t)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: amount is required and must be a bigint"});if("bigint"!=typeof o)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: cost is required and must be a bigint"});if("bigint"!=typeof c)throw(0,error_1.createError)({statusCode:400,message:"Cannot create order: fee is required and must be a bigint"});const p=new Date,m=`\n    INSERT INTO ${scyllaKeyspace}.orders (id, "userId", symbol, type, "timeInForce", side, price, amount, filled, remaining, cost, fee, "feeCurrency", status, "createdAt", "updatedAt", "marketMakerId", "botId", "walletType")\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);\n  `,g=(0,blockchain_1.removeTolerance)(a),y=(0,blockchain_1.removeTolerance)(t),f=(0,blockchain_1.removeTolerance)(o),E=(0,blockchain_1.removeTolerance)(c),b=(0,passwords_1.makeUuid)(),A=[b,e,r,s,"GTC",n,g.toString(),y.toString(),"0",y.toString(),f.toString(),E.toString(),i,"OPEN",p,p,l||null,d||null,u];try{await client_1.default.execute(m,A,{prepare:!0});return{id:b,userId:e,symbol:r,type:s,timeInForce:"GTC",side:n,price:g,amount:y,filled:BigInt(0),remaining:y,cost:f,fee:E,feeCurrency:i,average:BigInt(0),trades:"",status:"OPEN",createdAt:p,updatedAt:p,marketMakerId:l,botId:d,walletType:u}}catch(e){console_1.logger.error("SCYLLA",`Failed to create order: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to create order: ${e.message}`})}}async function addOrderToMatchingQueue(e){(await matchingEngine_1.MatchingEngine.getInstance()).addToQueue(e)}async function getHistoricalCandles(e,r,t,a){try{const o=`\n      SELECT * FROM ${scyllaKeyspace}.candles\n      WHERE symbol = ?\n      AND interval = ?\n      AND "createdAt" >= ?\n      AND "createdAt" <= ?\n      ORDER BY "createdAt" ASC;\n    `,s=[e,r,new Date(t),new Date(a)];let n=(await client_1.default.execute(o,s,{prepare:!0})).rows.map(e=>[e.createdAt.getTime(),e.open,e.high,e.low,e.close,e.volume]);const{fillCandleGaps:c,intervalDurations:i,normalizeToIntervalBoundary:l}=await Promise.resolve().then(()=>__importStar(require("../candles"))),d=i[r]||6e4;if(0===n.length){const o=`\n        SELECT * FROM ${scyllaKeyspace}.candles\n        WHERE symbol = ?\n        AND interval = ?\n        AND "createdAt" < ?\n        ORDER BY "createdAt" DESC\n        LIMIT 1;\n      `,s=[e,r,new Date(t)],n=await client_1.default.execute(o,s,{prepare:!0});if(n.rows.length>0){const e=n.rows[0],t=e.createdAt.getTime(),o=e.close,s=l(t,r),c=[];let i=s+d;const u=500;let p=0;for(;i<=a&&p<u;){c.push([i,o,o,o,o,0]);i+=d;p++}return c}return[]}n=c(n,r,t,a,500);return n}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch historical candles: ${e.message}`})}}async function getOrderBook(e){const r=`\n    SELECT * FROM ${scyllaKeyspace}.orderbook\n    WHERE symbol = ? AND side = 'ASKS'\n    LIMIT 50;\n  `,t=`\n    SELECT * FROM ${scyllaKeyspace}.orderbook\n    WHERE symbol = ? AND side = 'BIDS'\n    ORDER BY price DESC\n    LIMIT 50;\n  `,[a,o]=await Promise.all([client_1.default.execute(r,[e],{prepare:!0}),client_1.default.execute(t,[e],{prepare:!0})]);return{asks:a.rows.map(e=>[e.price,e.amount]),bids:o.rows.map(e=>[e.price,e.amount])}}async function getAllOpenOrders(){const e=`\n    SELECT DISTINCT symbol, side FROM ${scyllaKeyspace}.orderbook;\n  `;try{const r=await client_1.default.execute(e,[],{prepare:!0}),t=new Set;r.rows.forEach(e=>{e.symbol&&t.add(e.symbol)});const a=Array.from(t);if(0===a.length)return[];const o=[];for(const e of a){const r=`\n        SELECT * FROM ${scyllaKeyspace}.orders\n        WHERE status = 'OPEN' AND symbol = ?\n        ALLOW FILTERING;\n      `;try{const t=await client_1.default.execute(r,[e],{prepare:!0});o.push(...t.rows)}catch(r){console_1.logger.warn("SCYLLA",`Failed to fetch open orders for symbol ${e}: ${r.message}`)}}return o}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch all open orders: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch all open orders: ${e.message}`})}}async function getLastCandles(){try{const e=`\n      SELECT symbol, interval, open, high, low, close, volume, "createdAt", "updatedAt"\n      FROM ${scyllaKeyspace}.latest_candles;\n    `,r=await client_1.default.execute(e,[],{prepare:!0}),t={};r.rows.forEach(e=>{const r=`${e.symbol}:${e.interval}`,a={symbol:e.symbol,interval:e.interval,open:e.open,high:e.high,low:e.low,close:e.close,volume:e.volume,createdAt:new Date(e.createdAt),updatedAt:new Date(e.updatedAt)};(!t[r]||a.createdAt>t[r].createdAt)&&(t[r]=a)});return Object.values(t)}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch latest candles: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch latest candles: ${e.message}`})}}async function getLatestCandleForSymbol(e,r){try{const t=`\n      SELECT symbol, interval, open, high, low, close, volume, "createdAt", "updatedAt"\n      FROM ${scyllaKeyspace}.latest_candles\n      WHERE symbol = ? AND interval = ?\n      LIMIT 1;\n    `,a=await client_1.default.execute(t,[e,r],{prepare:!0});if(0===a.rows.length)return null;const o=a.rows[0];return{symbol:o.symbol,interval:o.interval,open:o.open,high:o.high,low:o.low,close:o.close,volume:o.volume,createdAt:new Date(o.createdAt),updatedAt:new Date(o.updatedAt)}}catch(t){console_1.logger.error("SCYLLA",`Failed to fetch latest candle for ${e}/${r}: ${t.message}`,t);return null}}async function getYesterdayCandles(){try{const e=new Date;e.setHours(0,0,0,0);const r=new Date(e.getTime()-864e5),t=`\n      SELECT * FROM ${scyllaKeyspace}.latest_candles\n      WHERE "createdAt" >= ? AND "createdAt" < ?;\n    `,a=await client_1.default.execute(t,[r.toISOString(),e.toISOString()],{prepare:!0}),o={};for(const e of a.rows){if("1d"!==e.interval)continue;const r={symbol:e.symbol,interval:e.interval,open:e.open,high:e.high,low:e.low,close:e.close,volume:e.volume,createdAt:new Date(e.createdAt),updatedAt:new Date(e.updatedAt)};o[e.symbol]||(o[e.symbol]=[]);o[e.symbol].push(r)}return o}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch yesterday's candles: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch yesterday's candles: ${e.message}`})}}async function generateOrderUpdateQueries(e){const r=[...new Set(e.map(e=>e.symbol))],t=new Map;await Promise.all(r.map(async e=>{const r=await getSymbolDecimals(e);t.set(e,r)}));return e.map(e=>{const r=getToleranceDigits(t.get(e.symbol)||8);return{query:`\n        UPDATE ${scyllaKeyspace}.orders\n        SET filled = ?, remaining = ?, status = ?, "updatedAt" = ?, trades = ?\n        WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n      `,params:[(0,blockchain_1.removeTolerance)(e.filled,r).toString(),(0,blockchain_1.removeTolerance)(e.remaining,r).toString(),e.status,new Date,JSON.stringify(e.trades),e.userId,e.createdAt,e.id]}})}async function fetchOrderBooks(){const e=`\n    SELECT * FROM ${scyllaKeyspace}.orderbook;\n  `;try{return(await client_1.default.execute(e)).rows.map(e=>({symbol:e.symbol,price:e.price,amount:e.amount,side:e.side}))}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch order books: ${e.message}`,e);return null}}async function updateOrderBookInDB(e,r,t,a){let o,s;if(t>0){o=`\n      INSERT INTO ${scyllaKeyspace}.orderbook (symbol, price, amount, side)\n      VALUES (?, ?, ?, ?);\n    `;s=[e,r,t,a.toUpperCase()]}else{o=`\n      DELETE FROM ${scyllaKeyspace}.orderbook\n      WHERE symbol = ? AND price = ? AND side = ?;\n    `;s=[e,r,a.toUpperCase()]}try{await client_1.default.execute(o,s,{prepare:!0})}catch(e){console_1.logger.error("SCYLLA",`Failed to update order book: ${e.message}`,e)}}async function deleteAllMarketData(e){const r=await client_1.default.execute(`\n      SELECT "userId", "createdAt", id\n      FROM ${scyllaKeyspace}.orders_by_symbol\n      WHERE symbol = ?\n      ALLOW FILTERING;\n    `,[e],{prepare:!0});for(const e of r.rows)await cancelAndRefundOrder(e.userId,e.id,e.createdAt);const t=r.rows.map(e=>({query:`\n      DELETE FROM ${scyllaKeyspace}.orders\n      WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n    `,params:[e.userId,e.createdAt,e.id]})),a=(await client_1.default.execute(`\n      SELECT interval, "createdAt"\n      FROM ${scyllaKeyspace}.candles\n      WHERE symbol = ?;\n    `,[e],{prepare:!0})).rows.map(r=>({query:`\n      DELETE FROM ${scyllaKeyspace}.candles\n      WHERE symbol = ? AND interval = ? AND "createdAt" = ?;\n    `,params:[e,r.interval,r.createdAt]})),o=["ASKS","BIDS"],s=[];for(const r of o){const t=(await client_1.default.execute(`\n        SELECT price\n        FROM ${scyllaKeyspace}.orderbook\n        WHERE symbol = ? AND side = ?;\n      `,[e,r],{prepare:!0})).rows.map(t=>({query:`\n        DELETE FROM ${scyllaKeyspace}.orderbook\n        WHERE symbol = ? AND side = ? AND price = ?;\n      `,params:[e,r,t.price]}));s.push(...t)}const n=[...t,...a,...s];if(0!==n.length)try{await client_1.default.batch(n,{prepare:!0})}catch(e){console_1.logger.error("SCYLLA",`Failed to delete all market data: ${e.message}`,e)}}async function cancelAndRefundOrder(e,r,t){const a=await getOrderByUuid(e,r,t);if(!a){console_1.logger.warn("SCYLLA",`Order not found for UUID: ${r}`);return}if("OPEN"!==a.status||BigInt(a.remaining)===BigInt(0))return;const o="BUY"===a.side?(0,blockchain_1.fromBigIntMultiply)(BigInt(a.remaining)+BigInt(a.fee),BigInt(a.price)):(0,blockchain_1.fromBigInt)(BigInt(a.remaining)+BigInt(a.fee)),s="BUY"===a.side?a.symbol.split("/")[1]:a.symbol.split("/")[0],n=await(0,wallet_1.getWalletByUserIdAndCurrency)(e,s);if(!n){console_1.logger.warn("SCYLLA",`${s} wallet not found for user ID: ${e}`);return}const c=`eco_order_refund_${r}_${n.id}`;await(0,wallet_1.updateWalletBalance)(n,o,"add",c)}async function getOrders(e,r,t){const a=`\n    SELECT * FROM ${scyllaKeyspace}.orders_by_symbol\n    WHERE symbol = ? AND "userId" = ?\n    ORDER BY "createdAt" DESC;\n  `,o=[r,e];try{return(await client_1.default.execute(a,o,{prepare:!0})).rows.map(mapRowToOrder).filter(e=>t?"OPEN"===e.status:"OPEN"!==e.status).map(e=>({...e,amount:(0,blockchain_1.fromBigInt)(e.amount),price:(0,blockchain_1.fromBigInt)(e.price),cost:(0,blockchain_1.fromBigInt)(e.cost),fee:(0,blockchain_1.fromBigInt)(e.fee),filled:(0,blockchain_1.fromBigInt)(e.filled),remaining:(0,blockchain_1.fromBigInt)(e.remaining)}))}catch(e){console_1.logger.error("SCYLLA",`Failed to fetch orders by userId and symbol: ${e.message}`,e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch orders by userId and symbol: ${e.message}`})}}async function rollbackOrderCreation(e,r,t){const a=`\n    DELETE FROM ${scyllaKeyspace}.orders\n    WHERE "userId" = ? AND "createdAt" = ? AND id = ?;\n  `,o=[r,t,e];await client_1.default.execute(a,o,{prepare:!0})}async function getRecentTrades(e,r=50){var t,a,o,s;try{const n=`\n      SELECT id, "userId", symbol, side, price, filled, trades, "updatedAt"\n      FROM ${scyllaKeyspace}.orders_by_symbol\n      WHERE symbol = ?\n      LIMIT ?\n      ALLOW FILTERING;\n    `,c=[e,2*r],i=await client_1.default.execute(n,c,{prepare:!0}),l=[];for(const e of i.rows)if(e.trades&&""!==e.trades&&"[]"!==e.trades)try{let r;if("string"==typeof e.trades){r=JSON.parse(e.trades);Array.isArray(r)||"string"!=typeof r||(r=JSON.parse(r))}else{if(!Array.isArray(e.trades))continue;r=e.trades}if(!Array.isArray(r)||0===r.length)continue;for(const t of r)l.push({id:t.id||`${e.id}_${t.timestamp}`,price:"bigint"==typeof t.price?(0,blockchain_1.fromBigInt)(t.price):t.price,amount:"bigint"==typeof t.amount?(0,blockchain_1.fromBigInt)(t.amount):t.amount,side:e.side.toLowerCase(),timestamp:t.timestamp||e.updatedAt.getTime()})}catch(r){console_1.logger.error("SCYLLA",`Failed to parse trades for order ${e.id}`,r);continue}const d=l.sort((e,r)=>r.timestamp-e.timestamp).slice(0,r);try{const n=`\n        SELECT id, price, amount, side, "createdAt", "isAiTrade"\n        FROM ${scyllaKeyspace}.trades\n        WHERE symbol = ?\n        LIMIT ?\n      `,c=await client_1.default.execute(n,[e,r],{prepare:!0});for(const e of c.rows)d.push({id:(null===(t=e.id)||void 0===t?void 0:t.toString())||`trade_${null===(a=e.createdAt)||void 0===a?void 0:a.getTime()}`,price:e.price,amount:e.amount,side:(null===(o=e.side)||void 0===o?void 0:o.toLowerCase())||"buy",timestamp:(null===(s=e.createdAt)||void 0===s?void 0:s.getTime())||Date.now(),isAiTrade:e.isAiTrade||!1});d.sort((e,r)=>r.timestamp-e.timestamp)}catch(e){console_1.logger.debug("SCYLLA",`Trades table query failed (may not exist yet): ${e.message}`)}return d.slice(0,r)}catch(r){console_1.logger.error("SCYLLA",`Failed to fetch recent trades for ${e}: ${r.message}`,r);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch recent trades: ${r.message}`})}}async function insertTrade(e,r,t,a,o=!1){try{const s=`\n      INSERT INTO ${scyllaKeyspace}.trades (symbol, "createdAt", id, price, amount, side, "isAiTrade")\n      VALUES (?, ?, ?, ?, ?, ?, ?)\n    `,n=cassandra_driver_1.types.Uuid.random(),c=new Date;await client_1.default.execute(s,[e,c,n,r,t,a.toUpperCase(),o],{prepare:!0})}catch(r){console_1.logger.error("SCYLLA",`Failed to insert trade for ${e}: ${r.message}`,r)}}async function getOHLCV(e,r,t=100){try{const a=`\n      SELECT open, high, low, close, volume, "createdAt"\n      FROM ${scyllaKeyspace}.candles\n      WHERE symbol = ? AND interval = ?\n      ORDER BY "createdAt" DESC\n      LIMIT ?;\n    `,o=[e,r,t],s=await client_1.default.execute(a,o,{prepare:!0});return s.rows.map(e=>[e.createdAt.getTime(),e.open,e.high,e.low,e.close,e.volume]).reverse()}catch(t){console_1.logger.error("SCYLLA",`Failed to fetch OHLCV for ${e} ${r}: ${t.message}`,t);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch OHLCV: ${t.message}`})}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,r,t,a){void 0===a&&(a=t);var o=Object.getOwnPropertyDescriptor(r,t);o&&!("get"in o?!r.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return r[t]}});Object.defineProperty(e,a,o)}:function(e,r,t,a){void 0===a&&(a=t);e[a]=r[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,r){Object.defineProperty(e,"default",{enumerable:!0,value:r})}:function(e,r){e.default=r}),__importStar=this&&this.__importStar||function(){var e=function(r){e=Object.getOwnPropertyNames||function(e){var r=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[r.length]=t);return r};return e(r)};return function(r){if(r&&r.__esModule)return r;var t={};if(null!=r)for(var a=e(r),o=0;o<a.length;o++)"default"!==a[o]&&__createBinding(t,r,a[o]);__setModuleDefault(t,r);return t}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.query=query;exports.getOrdersByUserId=getOrdersByUserId;exports.getOrderByUuid=getOrderByUuid;exports.cancelOrderByUuid=cancelOrderByUuid;exports.getOrderbookEntry=getOrderbookEntry;exports.createOrder=createOrder;exports.addOrderToMatchingQueue=addOrderToMatchingQueue;exports.getHistoricalCandles=getHistoricalCandles;exports.getOrderBook=getOrderBook;exports.getAllOpenOrders=getAllOpenOrders;exports.getLastCandles=getLastCandles;exports.getLatestCandleForSymbol=getLatestCandleForSymbol;exports.getYesterdayCandles=getYesterdayCandles;exports.generateOrderUpdateQueries=generateOrderUpdateQueries;exports.fetchOrderBooks=fetchOrderBooks;exports.updateOrderBookInDB=updateOrderBookInDB;exports.deleteAllMarketData=deleteAllMarketData;exports.getOrders=getOrders;exports.rollbackOrderCreation=rollbackOrderCreation;exports.getRecentTrades=getRecentTrades;exports.insertTrade=insertTrade;exports.getOHLCV=getOHLCV;const blockchain_1=require("../blockchain"),client_1=__importDefault(require("./client")),cassandra_driver_1=require("cassandra-driver"),passwords_1=require("@b/utils/passwords"),matchingEngine_1=require("../matchingEngine"),wallet_1=require("../wallet"),tokens_1=require("../tokens"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),scyllaKeyspace=process.env.SCYLLA_KEYSPACE||"trading",tokenDecimalsCache=new Map;