"use strict";async function getTokenDecimal(){try{return(await db_1.models.ecosystemToken.findAll({attributes:["currency","decimals"]})).reduce((e,t)=>{e[t.currency]=t.decimals;return e},{})}catch(e){console_1.logger.error("ECOSYSTEM","Failed to fetch token decimals",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch token decimals: ${e.message}`})}}function decodeTransactionData(e){if(e.startsWith("0xa9059cbb")){return{type:"ERC20",to:"0x"+e.slice(34,74),amount:BigInt(`0x${e.slice(74,138)}`)}}if(e.startsWith("0xf340fa01")){return{type:"Deposit",to:"0x"+e.slice(34,74)}}return"0x"===e?{type:"Native"}:{type:"Unknown"}}function toBigInt(e){const t=new bignumber_js_1.BigNumber(e).shiftedBy(18);return BigInt(t.toFixed())}function toBigIntFloat(e){const t=new bignumber_js_1.BigNumber(e).shiftedBy(18);return BigInt(t.toFixed(0))}function removeTolerance(e,t=2){const r=new bignumber_js_1.BigNumber(e.toString()),o=new bignumber_js_1.BigNumber(10).pow(t);return r.isLessThan(o)?e:BigInt(r.dividedToIntegerBy(o).multipliedBy(o).toFixed())}function fromBigInt(e){if(null===e)return 0;return new bignumber_js_1.BigNumber(e.toString()).shiftedBy(-18).toNumber()}function fromBigIntWithoutDivide(e){return new bignumber_js_1.BigNumber(e.toString()).toNumber()}function fromBigIntMultiply(e,t,r=18){const o=new bignumber_js_1.BigNumber(10).pow(r),i=new bignumber_js_1.BigNumber(e.toString()).div(o),n=new bignumber_js_1.BigNumber(t.toString()).div(o);return i.multipliedBy(n).toNumber()}function fromWei(e){return e/Math.pow(10,18)}function toWei(e){return e*Math.pow(10,18)}function convertBigInt(e){if(Array.isArray(e))return e.map(e=>convertBigInt(e));if(null!==e&&"object"==typeof e){const t={};for(const r in e)e[r]instanceof Date?t[r]=e[r].toISOString():"bigint"==typeof e[r]?t[r]=fromBigInt(e[r]):null===e[r]?t[r]=null:t[r]=convertBigInt(e[r]);return t}return"bigint"==typeof e?fromBigInt(e):e}async function cacheTokenDecimals(){try{const e=await getTokenDecimal(),t=redis_1.RedisSingleton.getInstance();await t.setex("token_decimals",86e3,JSON.stringify(e));console_1.logger.info("ECOSYSTEM","Cached token decimals")}catch(e){console_1.logger.error("ECOSYSTEM","Failed to cache token decimals in Redis",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to cache token decimals: ${e.message}`})}}async function getCachedTokenDecimals(){const e=redis_1.RedisSingleton.getInstance();let t;try{t=await e.get("token_decimals")}catch(e){console_1.logger.error("ECOSYSTEM","Failed to get cached token decimals from Redis",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to get cached token decimals: ${e.message}`})}if(t)return JSON.parse(t);try{await cacheTokenDecimals()}catch(e){console_1.logger.error("ECOSYSTEM","Failed to populate token decimals cache",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to cache token decimals: ${e.message}`})}try{t=await e.get("token_decimals")}catch(e){console_1.logger.error("ECOSYSTEM","Failed to get cached token decimals after population",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to get cached token decimals: ${e.message}`})}return t?JSON.parse(t):{}}function standardUnitToSatoshi(e,t){const r=getConversionFactor(t);return Math.round(e*r)}function satoshiToStandardUnit(e,t){return e/getConversionFactor(t)}function getConversionFactor(e){return{BTC:1e8,LTC:1e8,DOGE:1e8}[e]}Object.defineProperty(exports,"__esModule",{value:!0});exports.bitcoinCashNetwork=exports.dashNetwork=exports.dogecoinNetwork=exports.litecoinNetwork=exports.BigIntReplacer=exports.extractTransactionInfo=void 0;exports.getTokenDecimal=getTokenDecimal;exports.decodeTransactionData=decodeTransactionData;exports.toBigInt=toBigInt;exports.toBigIntFloat=toBigIntFloat;exports.removeTolerance=removeTolerance;exports.fromBigInt=fromBigInt;exports.fromBigIntWithoutDivide=fromBigIntWithoutDivide;exports.fromBigIntMultiply=fromBigIntMultiply;exports.fromWei=fromWei;exports.toWei=toWei;exports.convertBigInt=convertBigInt;exports.cacheTokenDecimals=cacheTokenDecimals;exports.getCachedTokenDecimals=getCachedTokenDecimals;exports.standardUnitToSatoshi=standardUnitToSatoshi;exports.satoshiToStandardUnit=satoshiToStandardUnit;const bignumber_js_1=require("bignumber.js"),redis_1=require("./redis"),db_1=require("@b/db"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),extractTransactionInfo=e=>{let t=null,r=null;if(e.data.startsWith("0x"))if("0x"===e.data){t=e.to;r="Direct transfer of main blockchain token"}else{switch(e.data.substring(0,10)){case"0xa9059cbb":t=`0x${e.data.substring(34,74)}`.toLowerCase();r=`ERC20 token transfer of ${parseInt(e.data.substring(74,138),16)} tokens`;break;case"0xf340fa01":t=`0x${e.data.substring(34,74)}`.toLowerCase();r="Deposit with an upline";break;default:r="Unknown function"}}return{targetAddress:t,details:r}};exports.extractTransactionInfo=extractTransactionInfo;const BigIntReplacer=(e,t)=>"bigint"==typeof t?t.toString():t;exports.BigIntReplacer=BigIntReplacer;exports.litecoinNetwork={messagePrefix:"Litecoin Signed Message:\n",bech32:"ltc",bip32:{public:27108450,private:27106558},pubKeyHash:48,scriptHash:50,wif:176};exports.dogecoinNetwork={messagePrefix:"Dogecoin Signed Message:\n",bech32:"doge",bip32:{public:49990397,private:49988504},pubKeyHash:30,scriptHash:22,wif:158};exports.dashNetwork={messagePrefix:"Dash Signed Message:\n",bech32:"dash",bip32:{public:50221816,private:50221772},pubKeyHash:76,scriptHash:16,wif:204};exports.bitcoinCashNetwork={messagePrefix:"Bitcoin Signed Message:\n",bech32:"bc",bip32:{public:76067358,private:76066276},pubKeyHash:0,scriptHash:5,wif:128};