"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/finance/wallet/utils"),blockchain_1=require("@b/api/(ext)/ecosystem/utils/blockchain"),matchingEngine_1=require("@b/api/(ext)/ecosystem/utils/matchingEngine"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),query_1=require("@b/utils/query");exports.metadata={summary:"Cancels all open trading orders",description:"Cancels all open trading orders for the user and refunds the unfulfilled amounts.",operationId:"cancelAllOrders",tags:["Trading","Orders"],logModule:"ECOSYSTEM",logTitle:"Cancel all trading orders",responses:{200:{description:"All orders cancelled successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},cancelledCount:{type:"number",description:"Number of orders cancelled"}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==t||t.step("Fetching all user orders");const e=await(0,queries_1.getOrdersByUserId)(r.id);null==t||t.step("Filtering open orders");const s=e.filter(e=>"OPEN"===e.status);if(0===s.length){null==t||t.success("No open orders to cancel");return{message:"No open orders to cancel",cancelledCount:0}}null==t||t.step(`Processing ${s.length} open orders`);const n=await matchingEngine_1.MatchingEngine.getInstance();let l=0;for(const e of s)try{const s=BigInt(e.amount),o=BigInt(e.remaining),i=BigInt(e.fee),a=BigInt(e.price),c=e.side,u=e.symbol;if(o===BigInt(0))continue;const[d,g]=u.split("/");let p=0;if("BUY"===c){const e=Number(o)/Number(s),r=o*a/BigInt(1e18),t=i*BigInt(Math.floor(1e18*e))/BigInt(1e18);p=(0,blockchain_1.fromBigInt)(r+t)}else p=(0,blockchain_1.fromBigInt)(o);const m="BUY"===c?g:d,f=await(0,utils_1.getWallet)(r.id,"ECO",m,!1,t);if(!f){console_1.logger.warn("ORDERS",`Wallet not found for ${m}, skipping order ${e.id}`);continue}await(0,queries_1.cancelOrderByUuid)(r.id,e.id,"string"==typeof e.createdAt?e.createdAt:e.createdAt.toISOString(),u,BigInt(e.price),c,s);const _=`eco_order_cancel_${e.id}_${f.id}`;await(0,wallet_1.updateWalletBalance)(f,p,"add",_);await n.handleOrderCancellation(e.id,u);l++}catch(r){console_1.logger.error("ORDERS",`Failed to cancel order ${e.id}`,r)}null==t||t.success(`Successfully cancelled ${l} of ${s.length} orders`);return{message:`Successfully cancelled ${l} order(s)`,cancelledCount:l}}catch(e){null==t||t.fail(`Failed to cancel orders: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to cancel orders: ${e.message}`})}};