"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.UTXODeposits=void 0;const deposit_1=require("@b/api/(ext)/ecosystem/utils/redis/deposit"),utxo_1=require("@b/api/(ext)/ecosystem/utils/utxo"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),db_1=require("@b/db"),blockchain_1=require("@b/api/(ext)/ecosystem/utils/blockchain"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class UTXODeposits{constructor(s){this.active=!0;this.consecutiveErrors=0;this.MAX_CONSECUTIVE_ERRORS=5;this.POLLING_INTERVAL=3e4;this.depositFound=!1;this.wallet=s.wallet;this.chain=s.chain;this.address=s.address;UTXODeposits.cleanupInterval||(UTXODeposits.cleanupInterval=setInterval(()=>UTXODeposits.cleanupProcessedTransactions(),6e4))}static cleanupProcessedTransactions(){const s=Date.now();for(const[t,e]of UTXODeposits.processedTxHashes.entries())s-e>UTXODeposits.PROCESSING_EXPIRY_MS&&UTXODeposits.processedTxHashes.delete(t)}async watchDeposits(){if(this.active){console_1.logger.info("UTXO_DEPOSIT",`Starting UTXO deposit monitoring for ${this.chain} address ${this.address}`);await this.startPolling()}else console_1.logger.debug("UTXO_DEPOSIT",`Monitor for ${this.chain} is not active, skipping watchDeposits`)}async startPolling(){const s=async()=>{var t,e,i;if(this.active&&!this.depositFound){try{console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Checking deposits for address ${this.address}`);const s=await(0,utxo_1.fetchUTXOTransactions)(this.chain,this.address);if(s&&0!==s.length){let o=0;for(const t of s){const s=`${this.wallet.id}-${t.hash}`;UTXODeposits.processedTxHashes.has(s)||o++}o>0&&console_1.logger.info("UTXO_DEPOSIT",`${this.chain} Found ${o} new transactions out of ${s.length} total for wallet ${this.wallet.id}. Already processed: ${UTXODeposits.processedTxHashes.size}`);for(const o of s){const s=`${this.wallet.id}-${o.hash}`;if(UTXODeposits.processedTxHashes.has(s))continue;if(await db_1.models.transaction.findOne({where:{trxId:o.hash,walletId:this.wallet.id}})){UTXODeposits.processedTxHashes.set(s,Date.now());continue}console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Processing transaction ${o.hash.substring(0,12)}...`);const n=(null===(t=chains_1.chainConfigs[this.chain])||void 0===t?void 0:t.confirmations)||3,a=o.confirmations||0,r=`confirmations-${s}`,c=UTXODeposits.lastBroadcastedConfirmations.get(r),h=void 0===c,l=c!==a;(h||l)&&console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Transaction ${o.hash.substring(0,12)}... has ${a}/${n} confirmations, value: ${o.value} for wallet ${this.wallet.id}`);if(a<n){if(h||l){console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Broadcasting pending status for ${o.hash.substring(0,12)}... to wallet ${this.wallet.id} (${a}/${n} confirmations)`);const s={walletId:this.wallet.id,chain:this.chain,hash:o.hash,transactionHash:o.hash,type:"pending_confirmation",from:"N/A",address:this.address,amount:(0,blockchain_1.satoshiToStandardUnit)(o.value||0,this.chain),fee:0,confirmations:a,requiredConfirmations:n,status:"PENDING"};await(0,deposit_1.storeAndBroadcastTransaction)(s,o.hash,!0);UTXODeposits.lastBroadcastedConfirmations.set(r,a);console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Pending broadcast sent for ${o.hash.substring(0,12)}... to wallet ${this.wallet.id}`)}}else{console_1.logger.info("UTXO_DEPOSIT",`${this.chain} Transaction ${o.hash.substring(0,12)}... is fully confirmed! Fetching full details...`);try{const t=await(0,utxo_1.fetchUtxoTransaction)(o.hash,this.chain);if(!t)throw(0,error_1.createError)({statusCode:500,message:"fetchUtxoTransaction returned null/undefined"});console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Full transaction details received: inputs=${(null===(e=t.inputs)||void 0===e?void 0:e.length)||0}, outputs=${(null===(i=t.outputs)||void 0===i?void 0:i.length)||0}`);const n=(t.inputs||[]).map(s=>({prev_hash:s.prev_hash,output_index:s.output_index,output_value:(0,blockchain_1.satoshiToStandardUnit)(s.output_value||0,this.chain),addresses:s.addresses,script:s.script})),a=(t.outputs||[]).map(s=>({value:(0,blockchain_1.satoshiToStandardUnit)(s.value||0,this.chain),addresses:s.addresses,script:s.script,spent_by:s.spender})),r=a.filter(s=>s.addresses&&s.addresses.includes(this.address)).reduce((s,t)=>s+t.value,0),c={id:this.wallet.id,chain:this.chain,hash:o.hash,type:"DEPOSIT",from:n.map(s=>s.addresses).flat(),to:a.map(s=>s.addresses).flat(),amount:r.toString(),fee:"0",status:"CONFIRMED",timestamp:o.confirmedTime?new Date(o.confirmedTime).getTime()/1e3:Math.floor(Date.now()/1e3),inputs:n,outputs:a};console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Storing confirmed deposit for ${o.hash.substring(0,12)}... with amount ${c.amount}`);await(0,deposit_1.storeAndBroadcastTransaction)(c,o.hash);UTXODeposits.processedTxHashes.set(s,Date.now());console_1.logger.success("UTXO_DEPOSIT",`${this.chain} Successfully processed and stored deposit ${o.hash.substring(0,12)}... for wallet ${this.wallet.id} - stopping monitor`);this.depositFound=!0;this.stopPolling();return}catch(s){console_1.logger.error("UTXO_DEPOSIT",`${this.chain} Failed to process confirmed transaction ${o.hash.substring(0,12)}... for wallet ${this.wallet.id}`);console_1.logger.error("UTXO_DEPOSIT",`${this.chain} Error details: ${s.message}`);console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Error stack: ${s.stack}`);continue}}}o>0&&!this.depositFound&&console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Finished processing ${o} new transactions. Total processed in session: ${UTXODeposits.processedTxHashes.size}`);if(this.depositFound){console_1.logger.info("UTXO_DEPOSIT",`${this.chain} Confirmed deposit found during this poll, stopping monitor`);return}this.consecutiveErrors=0}else{console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} No transactions found, waiting for next poll`);this.consecutiveErrors=0}}catch(s){this.consecutiveErrors++;console_1.logger.error("UTXO_DEPOSIT",`${this.chain} Error in polling cycle (attempt ${this.consecutiveErrors}/${this.MAX_CONSECUTIVE_ERRORS})`);console_1.logger.error("UTXO_DEPOSIT",`${this.chain} Error message: ${s.message}`);console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Error stack: ${s.stack}`);if(this.consecutiveErrors>=this.MAX_CONSECUTIVE_ERRORS){console_1.logger.error("UTXO_DEPOSIT",`${this.chain} Max consecutive errors reached, stopping monitor`);this.stopPolling();return}}if(this.active&&!this.depositFound){const t=this.consecutiveErrors>0?Math.min(this.POLLING_INTERVAL*Math.pow(2,this.consecutiveErrors-1),3e5):this.POLLING_INTERVAL;this.intervalId=setTimeout(s,t)}}else this.depositFound?console_1.logger.info("UTXO_DEPOSIT",`${this.chain} Deposit found and confirmed, stopping monitor`):console_1.logger.debug("UTXO_DEPOSIT",`${this.chain} Monitor inactive, skipping poll`)};await s()}stopPolling(){console_1.logger.info("UTXO_DEPOSIT",`Stopping UTXO deposit monitoring for ${this.chain}`);this.active=!1;if(this.intervalId){clearTimeout(this.intervalId);this.intervalId=void 0}console_1.logger.success("UTXO_DEPOSIT",`UTXO deposit monitoring stopped for ${this.chain}`)}}exports.UTXODeposits=UTXODeposits;UTXODeposits.processedTxHashes=new Map;UTXODeposits.lastBroadcastedConfirmations=new Map;UTXODeposits.PROCESSING_EXPIRY_MS=18e5;