"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("../../wallet/utils"),query_1=require("@b/utils/query");exports.metadata={summary:"Unlocks a specific deposit address",description:"Allows administrative unlocking of a custodial wallet deposit address to make it available for reuse. This is typically used for NO_PERMIT token addresses that need to be released after deposit completion.",operationId:"unlockDepositAddress",tags:["Wallet","Deposit"],logModule:"ECOSYSTEM",logTitle:"Unlock deposit address",parameters:[{name:"address",in:"query",description:"The deposit address to unlock (must be a valid address format)",required:!0,schema:{type:"string"}}],responses:{200:{description:"Deposit address unlocked successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message indicating the address has been unlocked."},address:{type:"string",description:"The address that was unlocked"},timestamp:{type:"string",description:"ISO timestamp of when the unlock occurred"}}}}}},400:{description:"Bad request - invalid parameters",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},statusCode:{type:"number"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Address"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{query:s,user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{address:a}=s;null==t||t.step("Validating address parameter");if(!a){null==t||t.fail("Address parameter missing");throw(0,error_1.createError)({statusCode:400,message:"Address parameter is required"})}if("string"!=typeof a){null==t||t.fail("Address parameter is not a string");throw(0,error_1.createError)({statusCode:400,message:"Address must be a string"})}const o=a.trim();if(0===o.length){null==t||t.fail("Address is empty");throw(0,error_1.createError)({statusCode:400,message:"Address cannot be empty"})}null==t||t.step("Validating address format");if(!(/^0x[a-fA-F0-9]{40}$/.test(o)||/^[13][a-km-zA-HJ-NP-Z1-9]{25,34}$/.test(o)||/^bc1[a-z0-9]{39,59}$/.test(o)||/^[A-Z0-9]{26,35}$/.test(o))){null==t||t.fail("Invalid address format");throw(0,error_1.createError)({statusCode:400,message:"Invalid address format"})}try{await(0,utils_1.unlockAddress)(o,t);return{message:"Address unlocked successfully",address:o,timestamp:(new Date).toISOString()}}catch(e){null==t||t.fail(`Failed to unlock address: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to unlock address: ${e.message}`})}};