"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Adds a product to the user's wishlist",description:"Allows a user to add a product to their wishlist if it's not already included.",operationId:"addToEcommerceWishlist",tags:["Ecommerce","Wishlist"],logModule:"ECOM",logTitle:"Add product to wishlist",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{productId:{type:"string",description:"Product ID to be added to the wishlist"}},required:["productId"]}}}},responses:(0,query_1.createRecordResponses)("Wishlist"),requiresAuth:!0};exports.default=async e=>{const{user:t,body:s,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{productId:i}=s;null==r||r.step("Finding or creating user wishlist");const[d]=await db_1.models.ecommerceWishlist.findOrCreate({where:{userId:t.id}});null==r||r.step("Checking if product is already in wishlist");if(await db_1.models.ecommerceWishlistItem.findOne({where:{wishlistId:d.id,productId:i}})){null==r||r.fail("Product already in wishlist");throw(0,error_1.createError)({statusCode:400,message:"Product already in wishlist"})}null==r||r.step("Adding product to wishlist");await db_1.models.ecommerceWishlistItem.create({wishlistId:d.id,productId:i});null==r||r.success(`Product ${i} added to wishlist`);return{message:"Product added to wishlist successfully"}};