"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Retrieves ecommerce statistics",description:"Fetches statistics for the ecommerce platform including product count, category count, and order count.",operationId:"getEcommerceStats",tags:["Ecommerce","Stats"],logModule:"ECOM",logTitle:"Get Stats",responses:{200:{description:"Stats retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{products:{type:"number",description:"Total number of active products"},categories:{type:"number",description:"Total number of active categories"},orders:{type:"number",description:"Total number of orders"}},required:["products","categories","orders"]}}}},500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching Ecommerce Stats");try{const[e,r,s]=await Promise.all([db_1.models.ecommerceProduct.count({where:{status:!0}}),db_1.models.ecommerceCategory.count({where:{status:!0}}),db_1.models.ecommerceOrder.count()]),o={products:e,categories:r,orders:s};null==t||t.success("Stats fetched successfully");return o}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error retrieving stats: ${e.message}`})}};