"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),affiliate_1=require("@b/utils/affiliate"),emails_1=require("@b/utils/emails"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications"),query_1=require("@b/utils/query"),Middleware_1=require("@b/handler/Middleware"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Creates a new order",description:"Processes a new order for the logged-in user, checking inventory, wallet balance, and applying any available discounts.",operationId:"createEcommerceOrder",tags:["Ecommerce","Orders"],requiresAuth:!0,logModule:"ECOM",logTitle:"Create order",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{productId:{type:"string",description:"Product ID to order"},discountId:{type:"string",description:"Discount ID applied to the order",nullable:!0},amount:{type:"number",description:"Quantity of the product to purchase"},shippingAddress:{type:"object",properties:{name:{type:"string"},email:{type:"string"},phone:{type:"string"},street:{type:"string"},city:{type:"string"},state:{type:"string"},postalCode:{type:"string"},country:{type:"string"}},required:["name","email","phone","street","city","state","postalCode","country"]}},required:["productId","amount"]}}}},responses:(0,query_1.createRecordResponses)("Order")};exports.default=async e=>{await Middleware_1.rateLimiters.orderCreation(e);const{user:t,body:r,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{productId:a,discountId:o,amount:s,shippingAddress:n}=r;null==i||i.step("Validating order request");if(!s||s<=0||!Number.isInteger(s))throw(0,error_1.createError)({statusCode:400,message:"Invalid quantity"});const d=await db_1.sequelize.transaction();null==i||i.step("Verifying user account");const c=await db_1.models.user.findByPk(t.id);if(!c)throw(0,error_1.createError)({statusCode:404,message:"User not found"});null==i||i.step("Checking product availability");const l=await db_1.models.ecommerceProduct.findByPk(a,{transaction:d});if(!l){await d.rollback();throw(0,error_1.createError)({statusCode:404,message:"Product not found"})}if(!l.status){await d.rollback();throw(0,error_1.createError)({statusCode:400,message:"Product is not available"})}null==i||i.step("Verifying inventory stock");if("PHYSICAL"===l.type&&l.inventoryQuantity<s){await d.rollback();throw(0,error_1.createError)({statusCode:400,message:"Insufficient inventory"})}null==i||i.step("Loading system settings for tax and shipping");const u=(await db_1.models.settings.findAll()).reduce((e,t)=>{e[t.key]=t.value;return e},{});null==i||i.step("Calculating order total");let p=l.price*s,m=null,y=0;if(o&&"null"!==o){null==i||i.step("Applying discount code");m=await db_1.models.ecommerceUserDiscount.findOne({where:{userId:t.id,discountId:o},include:[{model:db_1.models.ecommerceDiscount,as:"discount"}]});if(!m)throw(0,error_1.createError)({statusCode:404,message:"Discount not found"});"PERCENTAGE"===m.discount.type?y=p*(m.discount.percentage/100):"FIXED"===m.discount.type&&(y=Math.min(m.discount.value,p));p-=y}let g=0;"PHYSICAL"===l.type&&"true"===u.ecommerceShippingEnabled&&(g=parseFloat(u.ecommerceDefaultShippingCost||"0"));let f=0;if("true"===u.ecommerceTaxEnabled){f=p*(parseFloat(u.ecommerceDefaultTaxRate||"0")/100)}const w=p+g+f;null==i||i.step("Checking wallet balance");const b=await db_1.models.wallet.findOne({where:{userId:t.id,type:l.walletType,currency:l.currency},transaction:d,lock:d.LOCK.UPDATE});if(!b||b.balance<w){await d.rollback();throw(0,error_1.createError)({statusCode:400,message:"Insufficient balance"})}b.balance;null==i||i.step("Creating order record");const _=await db_1.models.ecommerceOrder.create({userId:t.id,status:"PENDING"},{transaction:d});await db_1.models.ecommerceOrderItem.create({orderId:_.id,productId:a,quantity:s},{transaction:d});null==i||i.step("Updating inventory");if("PHYSICAL"===l.type){const[e]=await db_1.models.ecommerceProduct.update({inventoryQuantity:(0,sequelize_1.literal)(`inventoryQuantity - ${s}`)},{where:{id:a,inventoryQuantity:{[sequelize_1.Op.gte]:s}},transaction:d});if(0===e){await d.rollback();throw(0,error_1.createError)({statusCode:400,message:"Product inventory changed during checkout"})}}null==i||i.step("Processing payment");const h=`Purchase of ${l.name} x${s} (${(l.price*s).toFixed(2)}${y>0?` - ${y.toFixed(2)} discount`:""}${g>0?` + ${g.toFixed(2)} shipping`:""}${f>0?` + ${f.toFixed(2)} tax`:""}) = ${w.toFixed(2)} ${l.currency}`,C=`ecom_order_${_.id}`;await wallet_1.walletService.debit({idempotencyKey:C,userId:t.id,walletId:b.id,walletType:l.walletType,currency:l.currency,amount:w,operationType:"ECOMMERCE_PURCHASE",referenceId:_.id,description:h,metadata:{orderId:_.id,productId:l.id,productName:l.name,quantity:s,subtotal:p+y,discountAmount:y,shippingCost:g,taxAmount:f},transaction:d});m&&await m.update({status:!0},{transaction:d});null==i||i.step("Creating shipping address");"DOWNLOADABLE"!==l.type&&n&&await db_1.models.ecommerceShippingAddress.create({userId:t.id,orderId:_.id,...n},{transaction:d});null==i||i.step("Finalizing order");await _.update({status:"COMPLETED"},{transaction:d});await d.commit();null==i||i.step("Sending confirmation email");try{await(0,emails_1.sendOrderConfirmationEmail)(c,_,l,i);await(0,notifications_1.createNotification)({userId:t.id,relatedId:_.id,title:"Order Confirmation",message:`Your order for ${l.name} x${s} has been confirmed.`,type:"system",link:`/ecommerce/orders/${_.id}`,actions:[{label:"View Order",link:`/ecommerce/orders/${_.id}`,primary:!0}]},i)}catch(e){console.error("Error sending order confirmation email or creating notification:",e)}if("DOWNLOADABLE"===l.type)try{await(0,affiliate_1.processRewards)(t.id,w,"ECOMMERCE_PURCHASE",b.currency,i)}catch(e){console.error(`Error processing rewards: ${e.message}`)}null==i||i.success(`Order #${_.id} created for ${w.toFixed(2)} ${l.currency}`);return{id:_.id,message:"Order created successfully"}};