"use strict";function getTimeAgo(e){const t=Math.floor((Date.now()-new Date(e).getTime())/1e3);return t<60?"just now":t<3600?`${Math.floor(t/60)}m ago`:t<86400?`${Math.floor(t/3600)}h ago`:t<604800?`${Math.floor(t/86400)}d ago`:`${Math.floor(t/604800)}w ago`}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Ecommerce Landing Page Data",description:"Retrieves optimized data for the ecommerce landing page including stats, best sellers, deals, and recent reviews.",operationId:"getEcommerceLandingData",tags:["Ecommerce","Landing"],requiresAuth:!1,responses:{200:{description:"Landing page data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{stats:{type:"object"},featuredProducts:{type:"array"},bestSellers:{type:"array"},newArrivals:{type:"array"},topRated:{type:"array"},activeDeals:{type:"array"},categoriesWithStats:{type:"array"},recentReviews:{type:"array"}}}}}}}};exports.default=async()=>{const e=new Date,t=new Date(e.getTime()-2592e6),[r,a,o,d,s,i,c,n,l]=await Promise.all([db_1.models.ecommerceProduct.count({where:{status:!0}}),db_1.models.ecommerceCategory.count({where:{status:!0}}),db_1.models.ecommerceOrder.count(),db_1.models.ecommerceOrder.findAll({where:{status:"COMPLETED"},include:[{model:db_1.models.ecommerceOrderItem,as:"ecommerceOrderItems",include:[{model:db_1.models.ecommerceProduct,as:"product"}]}]}),db_1.models.ecommerceReview.findAll({where:{status:!0},attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("rating")),"avgRating"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalCount"]],raw:!0}),db_1.models.ecommerceProduct.findAll({where:{status:!0},include:[{model:db_1.models.ecommerceCategory,as:"category"},{model:db_1.models.ecommerceReview,as:"ecommerceReviews",where:{status:!0},required:!1}],order:[["createdAt","DESC"]]}),db_1.models.ecommerceDiscount.findAll({where:{status:!0,validUntil:{[sequelize_1.Op.gt]:e}},include:[{model:db_1.models.ecommerceProduct,as:"product",where:{status:!0}}]}),db_1.models.ecommerceReview.findAll({where:{status:!0},include:[{model:db_1.models.ecommerceProduct,as:"product",attributes:["id","name","slug","image"]},{model:db_1.models.user,as:"user",attributes:["firstName","avatar"]}],order:[["createdAt","DESC"]],limit:6}),db_1.models.ecommerceCategory.findAll({where:{status:!0},include:[{model:db_1.models.ecommerceProduct,as:"ecommerceProducts",where:{status:!0},required:!1}]})]);let u=0;const m={};d.forEach(e=>{var t;null===(t=e.ecommerceOrderItems)||void 0===t||t.forEach(e=>{var t;const r=(null===(t=e.product)||void 0===t?void 0:t.price)||0;u+=r*e.quantity;const a=e.productId;m[a]=(m[a]||0)+e.quantity})});const g=i.map(e=>{const r=e.toJSON(),a=r.ecommerceReviews||[],o=a.length>0?a.reduce((e,t)=>e+t.rating,0)/a.length:0,d=m[r.id]||0;return{id:r.id,name:r.name,slug:r.slug,image:r.image,price:r.price,currency:r.currency,type:r.type,inventoryQuantity:r.inventoryQuantity,category:r.category?{name:r.category.name,slug:r.category.slug}:null,rating:Math.round(10*o)/10,reviewsCount:a.length,totalSold:d,isNew:new Date(r.createdAt)>t,isLowStock:r.inventoryQuantity>0&&r.inventoryQuantity<=5,createdAt:r.createdAt}}),p=[...g].sort((e,t)=>t.totalSold-e.totalSold).slice(0,4).filter(e=>e.totalSold>0).map(e=>({...e,badge:"bestseller"})),h=[...g].filter(e=>e.reviewsCount>=1).sort((e,t)=>t.rating-e.rating||t.reviewsCount-e.reviewsCount).slice(0,4).map(e=>({...e,badge:"top_rated"})),v=g.filter(e=>e.isNew).slice(0,4).map(t=>({...t,badge:"new",daysAgo:Math.floor((e.getTime()-new Date(t.createdAt).getTime())/864e5)})),y=new Set,w=[];p.forEach(e=>{if(!y.has(e.id)){y.add(e.id);w.push({...e,badge:"bestseller"})}});v.forEach(e=>{if(!y.has(e.id)&&w.length<8){y.add(e.id);w.push({...e,badge:"new"})}});h.forEach(e=>{if(!y.has(e.id)&&w.length<8){y.add(e.id);w.push({...e,badge:"top_rated"})}});g.forEach(e=>{if(!y.has(e.id)&&w.length<8){y.add(e.id);const t=e.isLowStock?"low_stock":null;w.push({...e,badge:t})}});const f=c.map(e=>{const t=e.toJSON(),r=t.product.price,a=r*(1-t.percentage/100);return{product:{id:t.product.id,name:t.product.name,slug:t.product.slug,image:t.product.image,price:r,currency:t.product.currency},discount:{code:t.code,percentage:t.percentage,validUntil:t.validUntil},originalPrice:r,discountedPrice:Math.round(100*a)/100}}),b=l.map(e=>{const t=e.toJSON(),r=t.ecommerceProducts||[],a=r.map(e=>e.price).filter(e=>e>0);return{id:t.id,name:t.name,slug:t.slug,image:t.image,productCount:r.length,avgPrice:a.length>0?Math.round(a.reduce((e,t)=>e+t,0)/a.length*100)/100:0,priceRange:{min:a.length>0?Math.min(...a):0,max:a.length>0?Math.max(...a):0},topProduct:r[0]?{name:r[0].name,slug:r[0].slug,image:r[0].image}:null}}),_=n.map(e=>{var t,r;const a=e.toJSON();return{id:a.id,product:a.product,user:{firstName:(null===(t=a.user)||void 0===t?void 0:t.firstName)||"Anonymous",avatar:null===(r=a.user)||void 0===r?void 0:r.avatar},rating:a.rating,comment:a.comment,timeAgo:getTimeAgo(a.createdAt)}}),A=new Set(d.map(e=>e.userId)).size,P=s[0];return{stats:{products:r,categories:a,orders:o,totalRevenue:Math.round(100*u)/100,avgRating:Math.round(10*parseFloat((null==P?void 0:P.avgRating)||0))/10,totalReviews:parseInt((null==P?void 0:P.totalCount)||0),customersServed:A,digitalProducts:g.filter(e=>"DOWNLOADABLE"===e.type).length,physicalProducts:g.filter(e=>"PHYSICAL"===e.type).length},featuredProducts:w,bestSellers:p,newArrivals:v,topRated:h,activeDeals:f,categoriesWithStats:b,recentReviews:_}};