"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),Middleware_1=require("@b/handler/Middleware");exports.metadata={summary:"Validate discount code",description:"Validates a discount code and returns discount information if valid.",operationId:"validateDiscountCode",tags:["Ecommerce","Discounts"],requiresAuth:!0,logModule:"ECOM",logTitle:"Validate discount code",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{code:{type:"string",description:"Discount code to validate"}},required:["code"]}}}},responses:{200:{description:"Discount code validation result",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string"},code:{type:"string"},type:{type:"string",enum:["PERCENTAGE","FIXED","FREE_SHIPPING"]},value:{type:"number"},message:{type:"string"},isValid:{type:"boolean"}}}}}},400:{description:"Invalid or expired discount code",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},isValid:{type:"boolean"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Discount"),500:query_1.serverErrorResponse}};exports.default=async e=>{await Middleware_1.rateLimiters.discountValidation(e);const{user:i,body:t,ctx:s}=e;if(!(null==i?void 0:i.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{code:r}=t;null==s||s.step("Validating discount code format");if(!r||"string"!=typeof r)throw(0,error_1.createError)({statusCode:400,message:"Discount code is required"});try{null==s||s.step("Looking up discount code");const e=await db_1.models.ecommerceDiscount.findOne({where:{code:r.toUpperCase().trim(),status:!0}});if(!e){null==s||s.fail("Invalid discount code");return{error:"Invalid discount code",isValid:!1}}const t=e.get({plain:!0}),o=new Date;null==s||s.step("Checking discount validity dates");if(t.validUntil&&new Date(t.validUntil)<o){null==s||s.fail("Discount code has expired");return{error:"This discount code has expired",isValid:!1}}if(t.validFrom&&new Date(t.validFrom)>o){null==s||s.fail("Discount code is not yet active");return{error:"This discount code is not yet active",isValid:!1}}null==s||s.step("Checking user usage history");if(1===t.maxUses){if(await db_1.models.ecommerceUserDiscount.findOne({where:{userId:i.id,discountId:t.id}})){null==s||s.fail("User has already used this discount code");return{error:"You have already used this discount code",isValid:!1}}}null==s||s.step("Checking usage limits");if(t.maxUses&&t.maxUses>0){if(await db_1.models.ecommerceUserDiscount.count({where:{discountId:t.id}})>=t.maxUses){null==s||s.fail("Discount code has reached usage limit");return{error:"This discount code has reached its usage limit",isValid:!1}}}let d="";switch(t.type){case"PERCENTAGE":d=`${t.percentage}% discount applied!`;break;case"FIXED":d=`$${t.amount} discount applied!`;break;case"FREE_SHIPPING":d="Free shipping applied!";break;default:d="Discount applied successfully!"}null==s||s.step("Creating user discount record");await db_1.models.ecommerceUserDiscount.create({userId:i.id,discountId:t.id});null==s||s.success(`Discount code "${t.code}" validated successfully`);return{id:t.id,code:t.code,type:t.type,value:"PERCENTAGE"===t.type?t.percentage:t.amount,message:d,isValid:!0}}catch(e){console.error("Discount validation error:",e);throw(0,error_1.createError)({statusCode:500,message:"Error validating discount code"})}};