"use strict";async function calculateLeaderStats(t){try{const e=await db_1.models.copyTradingFollower.count({where:{leaderId:t,status:{[sequelize_1.Op.ne]:"STOPPED"}}}),a=await db_1.models.copyTradingTrade.findAll({where:{leaderId:t,isLeaderTrade:!0,status:"CLOSED"},attributes:["profit","cost","fee"],raw:!0}),r=a.length,o=a.filter(t=>(t.profit||0)>0).length,l=a.reduce((t,e)=>t+(e.profit||0),0),s=a.reduce((t,e)=>t+(e.cost||0),0),c=r>0?o/r*100:0,i=s>0?l/s*100:0;return{totalFollowers:e,totalTrades:r,winRate:Math.round(100*c)/100,totalProfit:Math.round(100*l)/100,totalVolume:Math.round(100*s)/100,roi:Math.round(100*i)/100}}catch(e){console_1.logger.error("COPY_TRADING",`Failed to calculate leader stats for ${t}`,e);throw e}}async function getLeaderStats(t){const e=`copy:leader:stats:${t}`;try{const t=await redis.get(e);if(t)return JSON.parse(t)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache read failed for ${e}`,t)}const a=await calculateLeaderStats(t);try{await redis.set(e,JSON.stringify(a),"EX",CACHE_TTL.LEADER_STATS)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache write failed for ${e}`,t)}return a}async function invalidateLeaderStatsCache(t){const e=`copy:leader:stats:${t}`;try{await redis.del(e)}catch(t){console_1.logger.warn("COPY_TRADING",`Failed to invalidate cache for ${e}`,t)}}async function calculateFollowerStats(t){try{const e=await db_1.models.copyTradingTrade.findAll({where:{followerId:t,status:"CLOSED"},attributes:["profit","cost"],raw:!0}),a=e.length,r=e.filter(t=>(t.profit||0)>0).length,o=e.reduce((t,e)=>t+(e.profit||0),0),l=a>0?r/a*100:0,s=await db_1.models.copyTradingFollowerAllocation.findAll({where:{followerId:t,isActive:!0},attributes:["symbol","baseAmount","quoteAmount"],raw:!0});let c=0;for(const t of s)try{const[e,a]=t.symbol.split("/"),r=await(0,utils_1.getEcoPriceInUSD)(e),o=await(0,utils_1.getEcoPriceInUSD)(a);c+=parseFloat(t.baseAmount||0)*r+parseFloat(t.quoteAmount||0)*o}catch(e){console_1.logger.warn("COPY_TRADING",`Failed to get price for ${t.symbol}`,e)}const i=c>0?o/c*100:0;return{totalTrades:a,winRate:Math.round(100*l)/100,totalProfit:Math.round(100*o)/100,roi:Math.round(100*i)/100}}catch(e){console_1.logger.error("COPY_TRADING",`Failed to calculate follower stats for ${t}`,e);throw e}}async function getFollowerStats(t){const e=`copy:follower:stats:${t}`;try{const t=await redis.get(e);if(t)return JSON.parse(t)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache read failed for ${e}`,t)}const a=await calculateFollowerStats(t);try{await redis.set(e,JSON.stringify(a),"EX",CACHE_TTL.FOLLOWER_STATS)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache write failed for ${e}`,t)}return a}async function invalidateFollowerStatsCache(t){const e=`copy:follower:stats:${t}`;try{await redis.del(e)}catch(t){console_1.logger.warn("COPY_TRADING",`Failed to invalidate cache for ${e}`,t)}}async function calculateAllocationStats(t,e){try{const a=await db_1.models.copyTradingTrade.findAll({where:{followerId:t,symbol:e,status:"CLOSED"},attributes:["profit"],raw:!0}),r=a.length,o=a.filter(t=>(t.profit||0)>0).length,l=a.reduce((t,e)=>t+(e.profit||0),0),s=r>0?o/r*100:0;return{totalTrades:r,winRate:Math.round(100*s)/100,totalProfit:Math.round(100*l)/100}}catch(a){console_1.logger.error("COPY_TRADING",`Failed to calculate allocation stats for ${t}/${e}`,a);throw a}}async function getAllocationStats(t,e){const a=`copy:allocation:stats:${t}:${e}`;try{const t=await redis.get(a);if(t)return JSON.parse(t)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache read failed for ${a}`,t)}const r=await calculateAllocationStats(t,e);try{await redis.set(a,JSON.stringify(r),"EX",CACHE_TTL.ALLOCATION_STATS)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache write failed for ${a}`,t)}return r}async function invalidateAllocationStatsCache(t,e){const a=`copy:allocation:stats:${t}:${e}`;try{await redis.del(a)}catch(t){console_1.logger.warn("COPY_TRADING",`Failed to invalidate cache for ${a}`,t)}}async function calculateLeaderDailyStats(t,e){try{const a=new Date(e);a.setHours(0,0,0,0);const r=new Date(e);r.setHours(23,59,59,999);const o=(await db_1.models.copyTradingTrade.findAll({where:{leaderId:t,isLeaderTrade:!0,createdAt:{[sequelize_1.Op.between]:[a,r]}},attributes:["profit","cost","fee","status"],raw:!0})).filter(t=>"CLOSED"===t.status),l=o.length,s=o.filter(t=>(t.profit||0)>0).length,c=l-s,i=o.reduce((t,e)=>t+(e.profit||0),0),n=o.reduce((t,e)=>t+(e.cost||0),0),d=o.reduce((t,e)=>t+(e.fee||0),0);return{trades:l,winningTrades:s,losingTrades:c,profit:Math.round(100*i)/100,volume:Math.round(100*n)/100,fees:Math.round(100*d)/100}}catch(e){console_1.logger.error("COPY_TRADING",`Failed to calculate daily stats for leader ${t}`,e);throw e}}async function getLeaderDailyStats(t,e){const a=`copy:leader:daily:${t}:${e.toISOString().split("T")[0]}`;try{const t=await redis.get(a);if(t)return JSON.parse(t)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache read failed for ${a}`,t)}const r=await calculateLeaderDailyStats(t,e);try{await redis.set(a,JSON.stringify(r),"EX",CACHE_TTL.DAILY_STATS)}catch(t){console_1.logger.warn("COPY_TRADING",`Cache write failed for ${a}`,t)}return r}async function calculateBatchLeaderStats(t){try{const e=new Map,a=await db_1.models.copyTradingFollower.findAll({where:{leaderId:{[sequelize_1.Op.in]:t},status:{[sequelize_1.Op.ne]:"STOPPED"}},attributes:["leaderId"],raw:!0}),r=new Map;for(const t of a){const e=r.get(t.leaderId)||0;r.set(t.leaderId,e+1)}const o=await db_1.models.copyTradingTrade.findAll({where:{leaderId:{[sequelize_1.Op.in]:t},isLeaderTrade:!0,status:"CLOSED"},attributes:["leaderId","profit","cost"],raw:!0}),l=new Map;for(const t of o){const e=l.get(t.leaderId)||[];e.push(t);l.set(t.leaderId,e)}for(const a of t){const t=l.get(a)||[],o=t.length,s=t.filter(t=>(t.profit||0)>0).length,c=t.reduce((t,e)=>t+(e.profit||0),0),i=t.reduce((t,e)=>t+(e.cost||0),0),n=o>0?s/o*100:0,d=i>0?c/i*100:0;e.set(a,{totalFollowers:r.get(a)||0,totalTrades:o,winRate:Math.round(100*n)/100,totalProfit:Math.round(100*c)/100,totalVolume:Math.round(100*i)/100,roi:Math.round(100*d)/100})}return e}catch(t){console_1.logger.error("COPY_TRADING","Failed to calculate batch leader stats",t);throw t}}async function invalidateTradeRelatedCaches(t,e,a){const r=[];r.push(invalidateLeaderStatsCache(t));if(e){r.push(invalidateFollowerStatsCache(e));a&&r.push(invalidateAllocationStatsCache(e,a))}await Promise.all(r)}async function prewarmLeaderStatsCache(t){console_1.logger.info("COPY_TRADING",`Pre-warming stats cache for ${t.length} leaders`);for(const e of t)try{await getLeaderStats(e)}catch(t){console_1.logger.warn("COPY_TRADING",`Failed to pre-warm cache for leader ${e}`,t)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.calculateLeaderStats=calculateLeaderStats;exports.getLeaderStats=getLeaderStats;exports.invalidateLeaderStatsCache=invalidateLeaderStatsCache;exports.calculateFollowerStats=calculateFollowerStats;exports.getFollowerStats=getFollowerStats;exports.invalidateFollowerStatsCache=invalidateFollowerStatsCache;exports.calculateAllocationStats=calculateAllocationStats;exports.getAllocationStats=getAllocationStats;exports.invalidateAllocationStatsCache=invalidateAllocationStatsCache;exports.calculateLeaderDailyStats=calculateLeaderDailyStats;exports.getLeaderDailyStats=getLeaderDailyStats;exports.calculateBatchLeaderStats=calculateBatchLeaderStats;exports.invalidateTradeRelatedCaches=invalidateTradeRelatedCaches;exports.prewarmLeaderStatsCache=prewarmLeaderStatsCache;const db_1=require("@b/db"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/currency/utils"),redis_1=require("@b/utils/redis"),console_1=require("@b/utils/console"),redis=redis_1.RedisSingleton.getInstance(),CACHE_TTL={LEADER_STATS:300,FOLLOWER_STATS:300,ALLOCATION_STATS:180,DAILY_STATS:3600};