"use strict";async function onOrderCreated(e){try{const r=await db_1.models.copyTradingLeader.findOne({where:{userId:e.userId,status:"ACTIVE"}});if(!r)return;const t=r;if(!await db_1.models.copyTradingLeaderMarket.findOne({where:{leaderId:t.id,symbol:e.symbol,isActive:!0}})){console_1.logger.warn("COPY_TRADING",`Leader ${t.id} trading on undeclared market ${e.symbol} - skipping copy`);return}const o=await db_1.models.copyTradingFollower.count({where:{leaderId:t.id,status:"ACTIVE"}});if(0===o)return;const a=await db_1.models.copyTradingTrade.create({leaderId:t.id,symbol:e.symbol,side:e.side,type:e.type,amount:e.amount,price:e.price,cost:"BUY"===e.side?e.amount*e.price:e.amount,status:"PENDING_REPLICATION",orderId:e.id}),[,d]=e.symbol.split("/"),i=await(0,wallet_1.getWalletByUserIdAndCurrency)(e.userId,d),l=i?parseFloat(i.balance.toString()):0;(0,cron_1.replicateLeaderTrade)({id:a.id,leaderId:t.id,symbol:e.symbol,side:e.side,type:e.type,amount:e.amount,price:e.price,status:"PENDING_REPLICATION",createdAt:new Date},l).catch(e=>{console_1.logger.error("COPY_TRADING","Failed to replicate leader trade",e)});await(0,index_1.createAuditLog)({userId:e.userId,action:"TRADE_OPEN",entityType:"copyTradingTrade",entityId:a.id,metadata:{symbol:e.symbol,side:e.side,amount:e.amount,price:e.price,followers:o}})}catch(e){console_1.logger.error("COPY_TRADING","Error in onOrderCreated hook",e)}}async function onOrderClosed(e,r,t){try{const o=await db_1.models.copyTradingTrade.findOne({where:{orderId:e,followerId:null}});if(!o)return;const a=o;await a.update({profit:r,profitPercent:a.cost>0?r/a.cost*100:0,status:"CLOSED",closedAt:t});const d=await db_1.models.copyTradingTrade.findAll({where:{leaderTradeId:a.id,status:{[db_1.models.Sequelize.Op.ne]:"CLOSED"}}});for(const e of d)await e.update({status:"PENDING_CLOSE",closedProfit:r});await(0,stats_calculator_1.invalidateLeaderStatsCache)(a.leaderId);await(0,index_1.createAuditLog)({userId:a.leaderId,action:"TRADE_CLOSE",entityType:"copyTradingTrade",entityId:a.id,metadata:{profit:r,followerTrades:d.length}})}catch(e){console_1.logger.error("COPY_TRADING","Error in onOrderClosed hook",e)}}async function onFollowerOrderClosed(e,r,t){try{const o=await db_1.models.copyTradingTrade.findOne({where:{orderId:e,followerId:{[db_1.models.Sequelize.Op.ne]:null}},include:[{model:db_1.models.copyTradingFollower,as:"follower",include:[{model:db_1.models.copyTradingLeader,as:"leader"}]}]});if(!o)return;const a=o,d=a.follower,i=null==d?void 0:d.leader;await a.update({profit:r,profitPercent:a.cost>0?r/a.cost*100:0,status:"CLOSED",closedAt:t,closedProfit:r});if(r>0&&i){const e=2,t=i.profitSharePercent||20,o=r*(e/100),l=t/100*(r-o);await db_1.sequelize.transaction(async e=>{const r=a.profitCurrency||"USDT";await db_1.models.copyTradingTransaction.create({followerId:d.id,type:"PROFIT_SHARE",amount:l,currency:r,description:`Leader profit share for trade ${a.id}`,metadata:{tradeId:a.id,leaderId:i.id}},{transaction:e});await db_1.models.copyTradingTransaction.create({followerId:d.id,type:"PLATFORM_FEE",amount:o,currency:r,description:`Platform fee for trade ${a.id}`,metadata:{tradeId:a.id}},{transaction:e});const t=await(0,wallet_1.getWalletByUserIdAndCurrency)(i.userId,r);t&&await(0,wallet_1.updateWalletBalance)(t,l,"add",`ct_leader_profit_${a.id}`,e)})}const l=await db_1.models.copyTradingFollowerAllocation.findOne({where:{followerId:d.id,symbol:a.symbol,isActive:!0}});if(l){const e=l;"BUY"===a.side?await l.update({quoteUsedAmount:Math.max(0,e.quoteUsedAmount-a.cost)}):await l.update({baseUsedAmount:Math.max(0,e.baseUsedAmount-a.amount)});await(0,stats_calculator_1.invalidateAllocationStatsCache)(d.id,a.symbol)}await(0,stats_calculator_1.invalidateFollowerStatsCache)(d.id)}catch(e){console_1.logger.error("COPY_TRADING","Error in onFollowerOrderClosed hook",e)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.onOrderCreated=onOrderCreated;exports.onOrderClosed=onOrderClosed;exports.onFollowerOrderClosed=onFollowerOrderClosed;const db_1=require("@b/db"),cron_1=require("./cron"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),index_1=require("./index"),console_1=require("@b/utils/console"),stats_calculator_1=require("./stats-calculator");