"use strict";function calculateCopyAmount(e,r,t,a,o){if(o<=0)return{amount:0,cost:0,reason:"No available balance"};let s;const i=a.riskMultiplier||1;switch(a.copyMode){case"PROPORTIONAL":if(t<=0)return{amount:0,cost:0,reason:"Leader balance unknown"};s=o*(e*r/t)/r*i;break;case"FIXED_AMOUNT":{const e=a.fixedAmount||0;if(e<=0)return{amount:0,cost:0,reason:"Fixed amount not configured"};s=e/r*i;break}case"FIXED_RATIO":s=e*(a.fixedRatio||.1)*i;break;default:return{amount:0,cost:0,reason:"Invalid copy mode"}}a.maxPositionSize&&s>a.maxPositionSize&&(s=a.maxPositionSize);s*r>o&&(s=o/r);return{amount:Math.max(0,s),cost:Math.max(0,s*r)}}async function processCopyOrder(e){var r,t,a,o,s,i;const{leaderTrade:c,follower:n,leaderBalance:l}=e,d=Date.now(),u=await db_1.sequelize.transaction({isolationLevel:sequelize_1.Transaction.ISOLATION_LEVELS.SERIALIZABLE});try{const e=await db_1.models.copyTradingFollower.findByPk(n.id,{transaction:u,lock:u.LOCK.UPDATE});if(!e||"ACTIVE"!==e.status){await u.rollback();return{success:!1,error:"Follower is not active"}}const y=e,m=await db_1.models.copyTradingFollowerAllocation.findOne({where:{followerId:n.id,symbol:c.symbol,isActive:!0},transaction:u,lock:u.LOCK.UPDATE});if(!m){await u.rollback();return{success:!1,error:`No allocation for market ${c.symbol}`}}const p=m,b=await(0,dailyLimits_1.checkDailyLimits)(n.id);if(!b.canTrade){await u.rollback();return{success:!1,error:b.reason}}const f="BUY"===c.side?p.quoteAmount-p.quoteUsedAmount:p.baseAmount-p.baseUsedAmount;if(f<=0){await u.rollback();return{success:!1,error:`Insufficient allocation for ${c.symbol} ${c.side}. Available: ${f}`}}const{amount:w,cost:_,reason:I}=calculateCopyAmount(c.amount,c.price,l,y,f);if(w<=0){await u.rollback();return{success:!1,error:I||"Calculated amount is zero"}}const T=(0,currency_1.getBaseCurrency)(c.symbol),C=(0,currency_1.getQuoteCurrency)(c.symbol),A=await db_1.models.ecosystemMarket.findOne({where:{currency:T,pair:C},transaction:u});if(!A){await u.rollback();return{success:!1,error:`Market not found: ${c.symbol}`}}const O=A,k=Number((null===(a=null===(t=null===(r=O.metadata)||void 0===r?void 0:r.limits)||void 0===t?void 0:t.amount)||void 0===a?void 0:a.min)||0);if(w<k){await u.rollback();return{success:!1,error:`Amount ${w} ${T} below minimum ${k} ${T}`}}let q=c.price;if("MARKET"===c.type)try{const{asks:e,bids:r}=await(0,queries_1.getOrderBook)(c.symbol);"BUY"===c.side&&e&&e.length>0?q=e[0][0]:"SELL"===c.side&&r&&r.length>0&&(q=r[0][0])}catch(e){}const g=Number((null===(s=null===(o=O.metadata)||void 0===o?void 0:o.precision)||void 0===s?void 0:s.price)||8),h=Number((null===(i=O.metadata)||void 0===i?void 0:i.taker)||.1),$=parseFloat((w*q*h/100).toFixed(g)),{spend:v,receive:x}=(0,currency_1.getTradeCurrency)(c.symbol,c.side),B="BUY"===c.side?parseFloat((w*q+$).toFixed(g)):w,E=await(0,wallet_1.getWalletByUserIdAndCurrency)(n.userId,v,"COPY_TRADING",u,!0);if(!E){await u.rollback();return{success:!1,error:`Wallet not found for ${v}`}}const L=parseFloat(E.balance.toString());if(L<B){await u.rollback();return{success:!1,error:`Insufficient ${v} balance: ${L} < ${B}`}}const P=await(0,queries_1.createOrder)({userId:n.userId,symbol:c.symbol,amount:(0,blockchain_1.toBigIntFloat)(w),price:(0,blockchain_1.toBigIntFloat)(q),cost:(0,blockchain_1.toBigIntFloat)(B),type:"MARKET"===c.type?"MARKET":"LIMIT",side:c.side,fee:(0,blockchain_1.toBigIntFloat)($),feeCurrency:C,walletType:"COPY_TRADING"});await(0,wallet_1.updateWalletBalance)(E,B,"subtract",`ct_order_lock_${P.id}`,u);await(0,queries_1.addOrderToMatchingQueue)(P);const F=Date.now()-d,M=await db_1.models.copyTradingTrade.create({leaderId:c.leaderId,followerId:n.id,leaderOrderId:c.leaderOrderId,symbol:c.symbol,side:c.side,type:c.type,amount:w,price:q,cost:B,fee:$,feeCurrency:C,profitCurrency:C,status:"OPEN",isLeaderTrade:!1,latencyMs:F,executedAmount:0,executedPrice:0},{transaction:u});await y.update({totalTrades:(0,sequelize_1.literal)('"totalTrades" + 1')},{transaction:u});"BUY"===c.side?await p.update({quoteUsedAmount:(0,sequelize_1.literal)(`"quoteUsedAmount" + ${B}`),totalTrades:(0,sequelize_1.literal)('"totalTrades" + 1')},{transaction:u}):await p.update({baseUsedAmount:(0,sequelize_1.literal)(`"baseUsedAmount" + ${w}`),totalTrades:(0,sequelize_1.literal)('"totalTrades" + 1')},{transaction:u});await(0,dailyLimits_1.recordTrade)(n.id,B);await db_1.models.copyTradingTransaction.create({userId:n.userId,followerId:n.id,leaderId:c.leaderId,tradeId:M.id,type:"TRADE_OPEN",amount:B,currency:v,fee:0,balanceBefore:L,balanceAfter:L-B,description:`Copied ${c.side} trade: ${w.toFixed(6)} ${T} @ ${q} ${C}`,metadata:JSON.stringify({symbol:c.symbol,orderId:P.id,latencyMs:F,baseCurrency:T,quoteCurrency:C,spendCurrency:v,receiveCurrency:x}),status:"COMPLETED"},{transaction:u});await u.commit();return{success:!0,orderId:P.id,copyTradeId:M.id,amount:w,price:q,latencyMs:F}}catch(e){await u.rollback();console_1.logger.error("COPY_TRADING_ORDER",`Error processing copy order: ${e.message}`,e);return{success:!1,error:e.message}}}async function processCopyOrdersBatch(e,r,t,a=5){const o=[];let s=0,i=0;for(let c=0;c<r.length;c+=a){const n=r.slice(c,c+a),l=await Promise.all(n.map(r=>processCopyOrder({leaderTrade:e,follower:r,leaderBalance:t})));for(const e of l){o.push(e);e.success?s++:i++}}return{results:o,successCount:s,failCount:i}}async function processCopyOrderWithRetry(e,r=3,t=1e3){let a="";for(let o=1;o<=r;o++){const s=await processCopyOrder(e);if(s.success)return s;a=s.error||"Unknown error";if(a.includes("Insufficient balance")||a.includes("not active")||a.includes("daily limit"))return s;o<r&&await new Promise(e=>setTimeout(e,t*o))}return{success:!1,error:`Failed after ${r} attempts: ${a}`}}Object.defineProperty(exports,"__esModule",{value:!0});exports.calculateCopyAmount=calculateCopyAmount;exports.processCopyOrder=processCopyOrder;exports.processCopyOrdersBatch=processCopyOrdersBatch;exports.processCopyOrderWithRetry=processCopyOrderWithRetry;const db_1=require("@b/db"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries"),blockchain_1=require("@b/api/(ext)/ecosystem/utils/blockchain"),dailyLimits_1=require("./dailyLimits"),currency_1=require("./currency");