"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),stats_calculator_1=require("./utils/stats-calculator");exports.metadata={summary:"Get Copy Trading Platform Statistics",description:"Retrieves public statistics about the copy trading platform including total leaders, followers, volume, and average ROI.",operationId:"getCopyTradingStats",tags:["Copy Trading"],requiresAuth:!1,logModule:"COPY",logTitle:"Get platform stats",responses:{200:{description:"Statistics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalLeaders:{type:"number"},totalFollowers:{type:"number"},totalVolume:{type:"number"},avgRoi:{type:"number"},avgWinRate:{type:"number"},totalTrades:{type:"number"}}}}}},500:{description:"Internal Server Error"}}};exports.default=async t=>{const{ctx:e}=t;null==e||e.step("Fetching platform statistics");const a=await db_1.models.copyTradingLeader.findAll({where:{status:"ACTIVE",isPublic:!0},attributes:["id"],raw:!0}),s=a.length,r=a.map(t=>t.id),o=await db_1.models.copyTradingFollower.count({where:{status:{[sequelize_1.Op.in]:["ACTIVE","PAUSED"]}},distinct:!0,col:"userId"}),l=await(0,stats_calculator_1.calculateBatchLeaderStats)(r);let i=0,n=0,u=0,c=0,d=0;for(const t of l.values()){i+=t.totalVolume;c+=t.totalTrades;if(t.totalTrades>0){n+=t.roi;u+=t.winRate;d++}}const p=d>0?n/d:0,m=d>0?u/d:0;null==e||e.success("Statistics retrieved");return{totalLeaders:s,totalFollowers:o,totalVolume:Math.round(100*i)/100,avgRoi:Math.round(100*p)/100,avgWinRate:Math.round(100*m)/100,totalTrades:c}};