"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error"),stats_calculator_1=require("@b/api/(ext)/copy-trading/utils/stats-calculator");exports.metadata={summary:"Get My Leader Profile",description:"Retrieves the current user's leader profile if they are a leader.",operationId:"getMyLeaderProfile",tags:["Copy Trading","Leaders"],requiresAuth:!0,logModule:"COPY",logTitle:"Get my leader profile",responses:{200:{description:"Leader profile retrieved successfully",content:{"application/json":{schema:{type:"object"}}}},401:{description:"Unauthorized"},404:{description:"Not a leader"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==t||t.step("Fetching leader profile");const a=await db_1.models.copyTradingLeader.findOne({where:{userId:r.id},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]});if(!a)throw(0,error_1.createError)({statusCode:404,message:"You are not a leader"});null==t||t.step("Fetching follower stats");const s=await db_1.models.copyTradingFollower.findAll({where:{leaderId:a.id},attributes:["status",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["status"],raw:!0});null==t||t.step("Fetching recent transactions");const o=await db_1.models.copyTradingTransaction.findAll({where:{leaderId:a.id,type:"PROFIT_SHARE"},order:[["createdAt","DESC"]],limit:10});null==t||t.step("Fetching recent trades");const i=await db_1.models.copyTradingTrade.findAll({where:{leaderId:a.id,isLeaderTrade:!0},order:[["createdAt","DESC"]],limit:10});null==t||t.step("Calculating leader stats");const d=await(0,stats_calculator_1.getLeaderStats)(a.id);null==t||t.success("Leader profile retrieved");return{...a.toJSON(),...d,followerStats:s.reduce((e,r)=>{e[r.status]={count:parseInt(r.count)};return e},{}),recentTransactions:o.map(e=>e.toJSON()),recentTrades:i.map(e=>e.toJSON())}};