"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),utils_1=require("./utils");exports.metadata={summary:"Get Copy Trading Dashboard",description:"Retrieves the user's copy trading dashboard overview including leader profile (if any), subscriptions summary, and recent trades.",operationId:"getCopyTradingDashboard",tags:["Copy Trading"],requiresAuth:!0,logModule:"COPY",logTitle:"Get dashboard",responses:{200:{description:"Dashboard retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{isLeader:{type:"boolean"},leaderProfile:{type:"object",nullable:!0},subscriptions:{type:"object",properties:{active:{type:"number"},paused:{type:"number"},totalProfit:{type:"number"},totalROI:{type:"number"}}},recentTrades:{type:"array"},settings:{type:"object"}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching leader profile");const a=await(0,utils_1.getLeaderByUserId)(t.id),o=!!a&&"ACTIVE"===a.status;let s=null;if(a){const e=await db_1.models.copyTradingFollower.count({where:{leaderId:a.id,status:"ACTIVE"}}),t=await db_1.models.copyTradingFollower.count({where:{leaderId:a.id,status:"PAUSED"}}),r=0,o=await db_1.models.copyTradingTrade.findAll({where:{leaderId:a.id,followerId:null},order:[["createdAt","DESC"]],limit:5});s={...a.toJSON(),activeFollowers:e,pausedFollowers:t,totalAllocatedByFollowers:r,recentTrades:o.map(e=>e.toJSON())}}null==r||r.step("Fetching subscriptions");const i=await db_1.models.copyTradingFollower.findAll({where:{userId:t.id,status:{[sequelize_1.Op.ne]:"STOPPED"}},include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]}]}),l=i.filter(e=>"ACTIVE"===e.status).length,d=i.filter(e=>"PAUSED"===e.status).length,n=i.reduce((e,t)=>e+(t.totalProfit||0),0);null==r||r.step("Fetching recent trades");const u=i.map(e=>e.id);let c=[];u.length>0&&(c=await db_1.models.copyTradingTrade.findAll({where:{followerId:{[sequelize_1.Op.in]:u}},include:[{model:db_1.models.copyTradingLeader,as:"leader",attributes:["id","displayName"]}],order:[["createdAt","DESC"]],limit:10}));null==r||r.step("Fetching settings");const p=await(0,utils_1.getCopyTradingSettings)();null==r||r.success("Dashboard retrieved");return{isLeader:o,leaderProfile:s,subscriptions:{active:l,paused:d,total:i.length,totalProfit:n,totalROI:Math.round(0)/100,items:i.map(e=>e.toJSON())},recentTrades:c.map(e=>e.toJSON()),settings:{maxLeadersPerFollower:p.maxLeadersPerFollower,minAllocationAmount:p.minAllocationAmount,maxAllocationPercent:p.maxAllocationPercent}}};