"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("@b/api/(ext)/copy-trading/utils"),security_1=require("@b/api/(ext)/copy-trading/utils/security"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),wallet_2=require("@b/services/wallet"),affiliate_1=require("@b/utils/affiliate");exports.metadata={summary:"Follow a Copy Trading Leader",description:"Subscribe to a leader with per-market liquidity allocation for both base and quote currencies.",operationId:"followCopyTradingLeader",tags:["Copy Trading","Followers"],requiresAuth:!0,logModule:"COPY",logTitle:"Follow trader",middleware:["copyTradingFollow"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{leaderId:{type:"string",format:"uuid",description:"ID of the leader to follow"},allocations:{type:"array",items:{type:"object",properties:{symbol:{type:"string",description:"Market symbol (e.g., BTC/USDT)"},baseAmount:{type:"number",minimum:0,description:"Amount of base currency to allocate (for SELL orders)"},quoteAmount:{type:"number",minimum:0,description:"Amount of quote currency to allocate (for BUY orders)"}},required:["symbol"]},description:"Per-market allocation with base and quote currency amounts"},copyMode:{type:"string",enum:["PROPORTIONAL","FIXED_AMOUNT","FIXED_RATIO"],default:"PROPORTIONAL",description:"How to calculate copy trade amounts"},fixedAmount:{type:"number",description:"Fixed amount for FIXED_AMOUNT mode"},fixedRatio:{type:"number",description:"Fixed ratio for FIXED_RATIO mode"},maxDailyLoss:{type:"number",minimum:0,maximum:100,description:"Maximum daily loss percentage"},maxPositionSize:{type:"number",minimum:0,maximum:100,description:"Maximum position size percentage"},stopLossPercent:{type:"number",minimum:0,maximum:100,description:"Stop loss percentage"},takeProfitPercent:{type:"number",minimum:0,maximum:1e3,description:"Take profit percentage"}},required:["leaderId","allocations"]}}}},responses:{200:{description:"Successfully followed the leader",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},subscription:{type:"object"}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},429:{description:"Too Many Requests"},500:{description:"Internal Server Error"}}};exports.default=async e=>{var t,o;const{user:r,body:a,ctx:i}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==i||i.step("Validating request");const s=(0,security_1.validateFollowRequest)(a);s.valid||(0,security_1.throwValidationError)(s);const{leaderId:l,copyMode:n,fixedAmount:d,fixedRatio:u,maxDailyLoss:c,maxPositionSize:m,stopLossPercent:p,takeProfitPercent:f}=s.sanitized,{allocations:y}=a;if(!y||!Array.isArray(y)||0===y.length)throw(0,error_1.createError)({statusCode:400,message:"At least one market allocation is required"});null==i||i.step("Validating leader and markets");const b=await db_1.models.copyTradingLeader.findOne({where:{id:l,status:"ACTIVE"},include:[{model:db_1.models.copyTradingLeaderMarket,as:"markets",where:{isActive:!0},required:!1}]});if(!b)throw(0,error_1.createError)({statusCode:404,message:"Leader not found or not active"});if(b.userId===r.id)throw(0,error_1.createError)({statusCode:400,message:"You cannot follow yourself"});null==i||i.step("Checking for market conflicts");const w=await(0,security_1.checkMarketConflict)(r.id,l,y.map(e=>e.symbol));if(w.hasConflict){const e=w.conflictDetails[0];throw(0,error_1.createError)({statusCode:400,message:`You already have active allocations on ${e.markets.join(", ")} from leader "${e.leaderName}". You cannot follow multiple leaders on the same market.`})}const A=b.markets||[],g=new Map;for(const e of A)g.set(e.symbol,e);for(const e of y){const t=g.get(e.symbol);if(!t)throw(0,error_1.createError)({statusCode:400,message:`Market ${e.symbol} is not traded by this leader`});if((!e.baseAmount||e.baseAmount<=0)&&(!e.quoteAmount||e.quoteAmount<=0))throw(0,error_1.createError)({statusCode:400,message:`At least one of baseAmount or quoteAmount must be greater than 0 for ${e.symbol}`});const o=t.minBase||0,r=t.minQuote||0;if(o>0&&e.baseAmount>0&&e.baseAmount<o){const[t]=e.symbol.split("/");throw(0,error_1.createError)({statusCode:400,message:`${e.symbol}: Minimum ${t} allocation is ${o}`})}if(r>0&&e.quoteAmount>0&&e.quoteAmount<r){const[,t]=e.symbol.split("/");throw(0,error_1.createError)({statusCode:400,message:`${e.symbol}: Minimum ${t} allocation is ${r}`})}}null==i||i.step("Checking eligibility");const _=await(0,utils_1.checkFollowEligibility)(r.id,l,0);if(!_.eligible)throw(0,error_1.createError)({statusCode:400,message:_.reason||"Eligibility check failed"});null==i||i.step("Validating ECO wallet balances");const T=new Map;for(const e of y){const[t,o]=e.symbol.split("/");e.baseAmount&&e.baseAmount>0&&T.set(t,(T.get(t)||0)+e.baseAmount);e.quoteAmount&&e.quoteAmount>0&&T.set(o,(T.get(o)||0)+e.quoteAmount)}const C=new Map;for(const[e,o]of T){const a=await(0,wallet_1.getWalletByUserIdAndCurrency)(r.id,e,"ECO");if(!a)throw(0,error_1.createError)({statusCode:400,message:`ECO wallet not found for ${e}`});const i=parseFloat((null===(t=a.balance)||void 0===t?void 0:t.toString())||"0");if(i<o)throw(0,error_1.createError)({statusCode:400,message:`Insufficient ${e} balance in ECO wallet. Required: ${o.toFixed(8)}, Available: ${i.toFixed(8)}`});C.set(e,{wallet:a,balance:i})}null==i||i.step("Creating subscription");const I=await db_1.sequelize.transaction();try{const e=await db_1.models.copyTradingFollower.create({userId:r.id,leaderId:l,copyMode:n||"PROPORTIONAL",fixedAmount:"FIXED_AMOUNT"===n?d:null,fixedRatio:"FIXED_RATIO"===n?u:null,maxDailyLoss:c,maxPositionSize:m,stopLossPercent:p,takeProfitPercent:f,status:"ACTIVE"},{transaction:I});for(const t of y){const[o,a]=t.symbol.split("/");if(t.baseAmount&&t.baseAmount>0){const{wallet:a,balance:i}=C.get(o),s=`ct_follow_base_${e.id}_${t.symbol}`,n=await wallet_2.walletService.transfer({idempotencyKey:s,fromUserId:r.id,toUserId:r.id,fromWalletType:"ECO",toWalletType:"COPY_TRADING",fromCurrency:o,toCurrency:o,amount:t.baseAmount,description:`Transfer ${t.baseAmount} ${o} from ECO to CT wallet for ${t.symbol}`,metadata:{followerId:e.id,leaderId:l,symbol:t.symbol,currencyType:"BASE"},transaction:I});await(0,utils_1.createCopyTradingTransaction)({userId:r.id,leaderId:l,followerId:e.id,type:"ALLOCATION",amount:-t.baseAmount,currency:o,balanceBefore:n.fromResult.previousBalance,balanceAfter:n.fromResult.newBalance,description:`Transfer ${t.baseAmount} ${o} from ECO to CT wallet for ${t.symbol}`},I);await(0,utils_1.createCopyTradingTransaction)({userId:r.id,leaderId:l,followerId:e.id,type:"ALLOCATION",amount:t.baseAmount,currency:o,balanceBefore:n.toResult.previousBalance,balanceAfter:n.toResult.newBalance,description:`Received ${t.baseAmount} ${o} in CT wallet for ${t.symbol}`},I);C.set(o,{wallet:a,balance:n.fromResult.newBalance})}if(t.quoteAmount&&t.quoteAmount>0){const{wallet:o,balance:i}=C.get(a),s=`ct_follow_quote_${e.id}_${t.symbol}`,n=await wallet_2.walletService.transfer({idempotencyKey:s,fromUserId:r.id,toUserId:r.id,fromWalletType:"ECO",toWalletType:"COPY_TRADING",fromCurrency:a,toCurrency:a,amount:t.quoteAmount,description:`Transfer ${t.quoteAmount} ${a} from ECO to CT wallet for ${t.symbol}`,metadata:{followerId:e.id,leaderId:l,symbol:t.symbol,currencyType:"QUOTE"},transaction:I});await(0,utils_1.createCopyTradingTransaction)({userId:r.id,leaderId:l,followerId:e.id,type:"ALLOCATION",amount:-t.quoteAmount,currency:a,balanceBefore:n.fromResult.previousBalance,balanceAfter:n.fromResult.newBalance,description:`Transfer ${t.quoteAmount} ${a} from ECO to CT wallet for ${t.symbol}`},I);await(0,utils_1.createCopyTradingTransaction)({userId:r.id,leaderId:l,followerId:e.id,type:"ALLOCATION",amount:t.quoteAmount,currency:a,balanceBefore:n.toResult.previousBalance,balanceAfter:n.toResult.newBalance,description:`Received ${t.quoteAmount} ${a} in CT wallet for ${t.symbol}`},I);C.set(a,{wallet:o,balance:n.fromResult.newBalance})}await db_1.models.copyTradingFollowerAllocation.create({followerId:e.id,symbol:t.symbol,baseAmount:t.baseAmount||0,baseUsedAmount:0,quoteAmount:t.quoteAmount||0,quoteUsedAmount:0,isActive:!0},{transaction:I})}await(0,utils_1.createAuditLog)({entityType:"FOLLOWER",entityId:e.id,action:"FOLLOW",newValue:{...e.toJSON(),allocations:y},userId:r.id},I);await I.commit();null==i||i.step("Updating leader stats");await(0,utils_1.updateLeaderStats)(l);null==i||i.step("Fetching subscription details");const t=await db_1.models.copyTradingFollower.findByPk(e.id,{include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.copyTradingLeaderMarket,as:"markets",where:{isActive:!0},required:!1}]},{model:db_1.models.copyTradingFollowerAllocation,as:"allocations",where:{isActive:!0},required:!1}]});null==i||i.step("Sending follower notification");const a=null===(o=null==t?void 0:t.leader)||void 0===o?void 0:o.user,s=a?`${a.firstName} ${a.lastName}`:void 0;await(0,utils_1.notifyFollowerSubscriptionEvent)(e.id,"STARTED",{leaderName:s},i);null==i||i.step("Sending leader notification");await(0,utils_1.notifyLeaderNewFollower)(l,r.id,i);try{let e=0;for(const t of y)e+=(t.quoteAmount||0)+(t.baseAmount||0);e>0&&await(0,affiliate_1.processRewards)(r.id,e,"COPY_TRADING","USD")}catch(e){console.error("Failed to process affiliate rewards:",e)}null==i||i.success("Successfully followed leader");return{message:"Successfully subscribed to leader with multi-market allocation",subscription:null==t?void 0:t.toJSON()}}catch(e){await I.rollback();throw e}};