"use strict";function getPeriodDate(e){const t=new Date;switch(e){case"24h":return new Date(t.getTime()-864e5);case"7d":return new Date(t.getTime()-6048e5);case"30d":return new Date(t.getTime()-2592e6);case"90d":return new Date(t.getTime()-7776e6);case"1y":return new Date(t.getTime()-31536e6);default:return null}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/currency/utils");exports.metadata={summary:"Get My Copy Trading Analytics",description:"Retrieves comprehensive analytics for the user's copy trading activities.",operationId:"getMyCopyTradingAnalytics",tags:["Copy Trading","Analytics"],requiresAuth:!0,logModule:"COPY",logTitle:"Get analytics",parameters:[{name:"period",in:"query",required:!1,schema:{type:"string",enum:["24h","7d","30d","90d","1y","all"]},description:"Time period for analytics"}],responses:{200:{description:"Analytics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{summary:{type:"object",properties:{totalAllocated:{type:"number"},totalProfit:{type:"number"},overallROI:{type:"number"},activeSubscriptions:{type:"number"},totalTrades:{type:"number"},winRate:{type:"number"}}},byLeader:{type:"array"},profitChart:{type:"array"},tradeDistribution:{type:"object"}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,query:r,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const i=getPeriodDate(r.period||"30d");null==o||o.step("Fetching user subscriptions");const a=await db_1.models.copyTradingFollower.findAll({where:{userId:t.id},include:[{model:db_1.models.copyTradingLeader,as:"leader",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]},{model:db_1.models.copyTradingFollowerAllocation,as:"allocations",where:{isActive:!0},required:!1}]}),s=a.map(e=>e.id),n=a.filter(e=>"ACTIVE"===e.status).length;if(0===s.length){null==o||o.success("No subscriptions found");return{summary:{totalAllocated:0,totalProfit:0,overallROI:0,activeSubscriptions:0,totalTrades:0,winRate:0},byLeader:[],profitChart:[],tradeDistribution:{bySymbol:[],bySide:{buy:{count:0,profit:0},sell:{count:0,profit:0}}}}}null==o||o.step("Fetching trades");const l={followerId:{[sequelize_1.Op.in]:s},status:"CLOSED"};i&&(l.createdAt={[sequelize_1.Op.gte]:i});const d=await db_1.models.copyTradingTrade.findAll({where:l,include:[{model:db_1.models.copyTradingLeader,as:"leader",attributes:["id","displayName"]}]});null==o||o.step("Calculating analytics");const c=d.length,u=d.filter(e=>(e.profit||0)>0).length,p=d.reduce((e,t)=>e+(t.profit||0),0),y=c>0?u/c*100:0;let f=0;for(const e of a)if(e.allocations)for(const t of e.allocations)try{const[e,r]=t.symbol.split("/"),o=await(0,utils_1.getEcoPriceInUSD)(e),i=parseFloat(t.baseAmount||0)*o,a=await(0,utils_1.getEcoPriceInUSD)(r);f+=i+parseFloat(t.quoteAmount||0)*a}catch(e){console.error(`Failed to get price for ${t.symbol}:`,e)}const m=f>0?p/f*100:0,b={};d.forEach(e=>{var t;const r=e.leaderId;if(!b[r]){const o=a.find(e=>e.leaderId===r);b[r]={leader:(null===(t=e.leader)||void 0===t?void 0:t.toJSON())||{id:r},subscription:o?{id:o.id,status:o.status}:null,trades:0,wins:0,profit:0,volume:0}}b[r].trades++;(e.profit||0)>0&&b[r].wins++;b[r].profit+=e.profit||0;b[r].volume+=e.cost||0});const h=Object.values(b).map(e=>({...e,winRate:e.trades>0?e.wins/e.trades*100:0,roi:0,profit:Math.round(100*e.profit)/100,volume:Math.round(100*e.volume)/100})),g={};d.forEach(e=>{const t=new Date(e.createdAt).toISOString().split("T")[0];g[t]=(g[t]||0)+(e.profit||0)});const v=Object.keys(g).sort();let w=0;const T=v.map(e=>{w+=g[e];return{date:e,dailyProfit:Math.round(100*g[e])/100,cumulativeProfit:Math.round(100*w)/100}}),A={};d.forEach(e=>{const t=e.symbol||"UNKNOWN";A[t]||(A[t]={count:0,profit:0});A[t].count++;A[t].profit+=e.profit||0});const _=d.filter(e=>"BUY"===e.side),D=d.filter(e=>"SELL"===e.side);null==o||o.success("Analytics retrieved successfully");return{summary:{totalAllocated:Math.round(100*f)/100,totalProfit:Math.round(100*p)/100,overallROI:Math.round(100*m)/100,activeSubscriptions:n,totalTrades:c,winRate:Math.round(100*y)/100},byLeader:h,profitChart:T,tradeDistribution:{bySymbol:Object.entries(A).map(([e,t])=>({symbol:e,...t,profit:Math.round(100*t.profit)/100})),bySide:{buy:{count:_.length,profit:_.reduce((e,t)=>e+(t.profit||0),0)},sell:{count:D.length,profit:D.reduce((e,t)=>e+(t.profit||0),0)}}}}};