"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Retrieves all investments for the logged-in user",description:"Fetches all AI trading investments for the currently authenticated user, excluding active investments.",operationId:"getAllInvestments",tags:["AI Trading"],responses:{200:{description:"Investments retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseInvestmentSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("AI Investment"),500:query_1.serverErrorResponse},logModule:"AI",logTitle:"Get all AI investments",requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching all user investments");const r=await db_1.models.aiInvestment.findAll({where:{userId:t.id},include:[{model:db_1.models.aiInvestmentPlan,as:"plan",attributes:["title","profitPercentage"]},{model:db_1.models.aiInvestmentDuration,as:"duration",attributes:["duration","timeframe"]}],attributes:["id","symbol","type","amount","profit","result","status","createdAt"],order:[["status","ASC"],["createdAt","ASC"]]});null==s||s.success(`Retrieved ${r.length} investment(s)`);return r};