"use strict";async function getAffiliateDashboard(e){const{user:r,query:t,ctx:a}=e,s=null==r?void 0:r.id;if(!s)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Parsing period parameter");const l=(null==t?void 0:t.period)||"6m";let d=6;switch(l){case"1m":d=1;break;case"3m":d=3;break;case"6m":d=6;break;case"1y":d=12}const o=new Date,n=new Date(o.getFullYear(),o.getMonth()-(d-1),1),i=new Date(o.getFullYear(),o.getMonth()-(2*d-1),1),u=new Date(n.getFullYear(),n.getMonth(),0);null==a||a.step("Loading MLM system settings");const m=cache_1.CacheManager.getInstance(),c="true"===(await m.getSettings()).get("referralApprovalRequired");null==a||a.step(`Fetching dashboard statistics for ${l} period`);const[f,h,w,p,b,g,_,A,R,q,I,z]=await Promise.all([db_1.models.mlmReferral.count({where:{referrerId:s}}),db_1.models.mlmReferral.count({where:{referrerId:s,status:"ACTIVE"}}),db_1.models.mlmReferral.count({where:{referrerId:s,status:"PENDING"}}),db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"totalEarnings"]],where:{referrerId:s},raw:!0}),db_1.models.mlmReferral.count({where:{referrerId:s,createdAt:{[sequelize_1.Op.gte]:n}}}),db_1.models.mlmReferral.count({where:{referrerId:s,createdAt:{[sequelize_1.Op.lte]:u}}}),db_1.models.mlmReferralReward.count({where:{referrerId:s,createdAt:{[sequelize_1.Op.gte]:n}}}),db_1.models.mlmReferral.count({where:{referrerId:s,createdAt:{[sequelize_1.Op.between]:[i,u]}}}),db_1.models.mlmReferral.count({where:{referrerId:s,status:"ACTIVE",createdAt:{[sequelize_1.Op.between]:[i,u]}}}),db_1.models.mlmReferral.count({where:{referrerId:s,status:"PENDING",createdAt:{[sequelize_1.Op.between]:[i,u]}}}),db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"amount"]],where:{referrerId:s,createdAt:{[sequelize_1.Op.between]:[i,u]}},raw:!0}),db_1.models.mlmReferralReward.count({where:{referrerId:s,createdAt:{[sequelize_1.Op.between]:[i,u]}}})]),M=parseFloat(p.totalEarnings)||0,E=b&&g>0?Math.round((b-g)/g*100):0,D=f>0?Math.round(_/f*100):0;parseFloat(null==I?void 0:I.amount),A>0&&Math.round(z/A*100);null==a||a.step("Computing statistics and growth metrics");const F={totalReferrals:f,activeReferrals:h,pendingReferrals:w,conversionRate:D,totalEarnings:M,weeklyGrowth:E};null==a||a.step("Fetching referrals for current period");const O={referrerId:s,createdAt:{[sequelize_1.Op.gte]:n}};c&&(O.status="ACTIVE");const y=await db_1.models.mlmReferral.findAll({where:O,include:[{model:db_1.models.user,as:"referred",attributes:["firstName","lastName","email","avatar"]}],order:[["createdAt","DESC"]]});null==a||a.step("Fetching reward history");const v=await db_1.models.mlmReferralReward.findAll({where:{referrerId:s},include:[{model:db_1.models.mlmReferralCondition,as:"condition",attributes:["name"]}],order:[["createdAt","DESC"]]});null==a||a.step("Generating monthly earnings breakdown");const C=[];for(let e=d-1;e>=0;e--){const r=new Date(o.getFullYear(),o.getMonth()-e,1);C.push(`${r.getFullYear()}-${String(r.getMonth()+1).padStart(2,"0")}`)}const S=await db_1.models.mlmReferralReward.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),"%Y-%m"),"month"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"amount"]],where:{referrerId:s,createdAt:{[sequelize_1.Op.gte]:n}},group:["month"],raw:!0}),T=Object.fromEntries(S.map(e=>[e.month,parseFloat(e.amount)])),x=C.map(e=>({month:e,earnings:T[e]||0}));null==a||a.success(`Retrieved dashboard data: ${f} referrals, ${M.toFixed(2)} total earnings`);return{stats:F,referrals:y,rewards:v,monthlyEarnings:x}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.default=getAffiliateDashboard;const db_1=require("@b/db"),error_1=require("@b/utils/error"),cache_1=require("@b/utils/cache"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Affiliate Dashboard",description:"Retrieves dashboard data for the authenticated affiliate, with optional period filtering.",operationId:"getAffiliateDashboard",tags:["Affiliate","Dashboard"],requiresAuth:!0,logModule:"AFFILIATE",logTitle:"Get affiliate dashboard",parameters:[{name:"period",in:"query",required:!1,schema:{type:"string",enum:["1m","3m","6m","1y"]}}],responses:{200:{description:"Affiliate dashboard data retrieved successfully."},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};