"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications");exports.metadata={summary:"Create Staking Pool",description:"Creates a new staking pool with the provided details.",operationId:"createStakingPool",tags:["Staking","Admin","Pools"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Create Staking Pool",requestBody:{description:"Staking pool data",required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string"},token:{type:"string"},symbol:{type:"string"},icon:{type:"string"},description:{type:"string"},apr:{type:"number"},lockPeriod:{type:"number"},minStake:{type:"number"},maxStake:{type:"number",nullable:!0},totalStaked:{type:"number"},availableToStake:{type:"number"},earlyWithdrawalFee:{type:"number"},adminFeePercentage:{type:"number"},status:{type:"string",enum:["ACTIVE","INACTIVE","COMING_SOON"]},isPromoted:{type:"boolean"},order:{type:"number"},earningFrequency:{type:"string",enum:["DAILY","WEEKLY","MONTHLY","END_OF_TERM"]},autoCompound:{type:"boolean"},externalPoolUrl:{type:"string"},profitSource:{type:"string"},fundAllocation:{type:"string"},risks:{type:"string"},rewards:{type:"string"}},required:["name","token","symbol","description","apr","lockPeriod","minStake","totalStaked","availableToStake","earlyWithdrawalFee","adminFeePercentage","status","earningFrequency"]}}}},responses:{201:{description:"Pool created successfully",content:{"application/json":{schema:{type:"object"}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"create.staking.pool"};exports.default=async e=>{const{user:t,body:r,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});if(!r)throw(0,error_1.createError)({statusCode:400,message:"Request body is required"});try{null==o||o.step("Get highest order value");const e=await db_1.models.stakingPool.findOne({attributes:["order"],order:[["order","DESC"]],raw:!0}),a=e?e.order+1:1;null==o||o.step("Create staking pool");const i=await db_1.models.stakingPool.create({...r,order:r.order||a});try{await(0,notifications_1.createNotification)({userId:t.id,relatedId:i.id,type:"system",title:"Staking Pool Created",message:`New staking pool "${i.name}" has been created successfully.`,details:"The pool is now available in the admin dashboard.",link:`/admin/staking/pools/${i.id}`,actions:[{label:"View Pool",link:`/admin/staking/pools/${i.id}`,primary:!0}]},o)}catch(e){console.error("Failed to create notification for pool creation",e)}null==o||o.success("Staking pool created successfully");return i}catch(e){console.error("Error creating staking pool:",e);if("SequelizeValidationError"===e.name){const t={};e.errors.forEach(e=>{t[e.path]=e.message});const r=(0,error_1.createError)({statusCode:400,message:"Validation failed. Please check the required fields."});r.validationErrors=t;throw r}if("SequelizeUniqueConstraintError"===e.name)throw(0,error_1.createError)({statusCode:400,message:"A pool with this name or symbol already exists"});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to create staking pool"})}};