"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists Staking Pools with associated positions, admin earnings, and performances",operationId:"listStakingPools",tags:["Staking","Admin","Pools"],parameters:constants_1.crudParameters,responses:{401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Staking Pools"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get Staking Pools",permission:"view.staking.pool"};exports.default=async e=>{const{user:s,query:r,ctx:o}=e;null==o||o.step("Fetching data");if(!s)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==o||o.success("Operation completed successfully");return(0,query_1.getFiltered)({model:db_1.models.stakingPool,query:r,sortField:r.sortField||"createdAt",includeModels:[{model:db_1.models.stakingPosition,as:"positions",required:!1},{model:db_1.models.stakingAdminEarning,as:"adminEarnings",required:!1},{model:db_1.models.stakingExternalPoolPerformance,as:"performances",required:!1}],compute:[[(0,sequelize_1.literal)("(\n          SELECT COALESCE(SUM(sp.amount), 0)\n          FROM staking_positions AS sp\n          WHERE sp.poolId = stakingPool.id\n        )"),"totalStaked"]]})};