"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Staking Pools",description:"Retrieves all staking pools with optional filtering by status, search term, APR range, and token.",operationId:"getStakingPools",tags:["Staking","Admin","Pools"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get All Staking Pools",parameters:[{index:0,name:"status",in:"query",required:!1,schema:{type:"string",enum:["ACTIVE","INACTIVE","COMING_SOON"]},description:"Filter pools by status"},{index:1,name:"search",in:"query",required:!1,schema:{type:"string"},description:"Search term to filter pools by name, token, or symbol"},{index:2,name:"minApr",in:"query",required:!1,schema:{type:"number"},description:"Minimum APR value"},{index:3,name:"maxApr",in:"query",required:!1,schema:{type:"number"},description:"Maximum APR value"},{index:4,name:"token",in:"query",required:!1,schema:{type:"string"},description:"Filter pools by token"}],responses:{200:{description:"Pools retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"view.staking.pool"};exports.default=async e=>{const{user:r,query:t,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==s||s.step("Fetching data");const e={};(null==t?void 0:t.status)&&(e.status=t.status);if(null==t?void 0:t.search){const r=`%${t.search}%`;e[sequelize_1.Op.or]=[{name:{[sequelize_1.Op.like]:r}},{token:{[sequelize_1.Op.like]:r}},{symbol:{[sequelize_1.Op.like]:r}}]}void 0!==(null==t?void 0:t.minApr)&&(e.apr={...e.apr,[sequelize_1.Op.gte]:Number.parseFloat(t.minApr)});void 0!==(null==t?void 0:t.maxApr)&&(e.apr={...e.apr,[sequelize_1.Op.lte]:Number.parseFloat(t.maxApr)});(null==t?void 0:t.token)&&(e.token=t.token);const r=await db_1.models.stakingPool.findAll({where:e,attributes:{include:[[(0,sequelize_1.literal)("(\n              SELECT COALESCE(SUM(sp.amount), 0)\n              FROM staking_positions AS sp\n              WHERE sp.poolId = stakingPool.id\n            )"),"totalStaked"]]},include:[{model:db_1.models.stakingPosition,as:"positions",required:!1},{model:db_1.models.stakingAdminEarning,as:"adminEarnings",required:!1},{model:db_1.models.stakingExternalPoolPerformance,as:"performances",required:!1}],order:[["order","ASC"]]});null==s||s.success("Operation completed successfully");return r}catch(e){console.error("Error fetching staking pools:",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch staking pools"})}};