"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),notifications_1=require("@b/utils/notifications"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create Admin Earning Record",operationId:"createAdminEarning",description:"Creates a new admin earning record for a staking pool. Admin earnings represent platform fees, early withdrawal fees, performance fees, or other earnings collected by the platform from the staking pool operations.",tags:["Admin","Staking","Earnings"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Add Admin Earning",requestBody:{description:"Admin earning data",required:!0,content:{"application/json":{schema:{type:"object",properties:{poolId:{type:"string",format:"uuid",description:"ID of the staking pool"},date:{type:"string",format:"date-time",description:"Date when the earning was generated"},amount:{type:"number",minimum:0,description:"Amount of the earning"},isClaimed:{type:"boolean",description:"Whether the earning has been claimed",default:!1},type:{type:"string",enum:["PLATFORM_FEE","EARLY_WITHDRAWAL_FEE","PERFORMANCE_FEE","OTHER"],description:"Type of admin earning"},status:{type:"string",description:"Status of the earning record"},currency:{type:"string",description:"Currency/token symbol of the earning"}},required:["poolId","date","amount","type","status","currency"]}}}},responses:{201:{description:"Admin earning record created successfully",content:{"application/json":{schema:{type:"object",properties:{...errors_1.commonFields,poolId:{type:"string",format:"uuid"},amount:{type:"number"},isClaimed:{type:"boolean"},type:{type:"string",enum:["PLATFORM_FEE","EARLY_WITHDRAWAL_FEE","PERFORMANCE_FEE","OTHER"]},currency:{type:"string"},pool:{type:"object",description:"Associated staking pool details"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Staking Pool"),500:errors_1.serverErrorResponse},permission:"create.staking.earning"};exports.default=async e=>{const{user:r,body:t,ctx:n}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});if(!t)throw(0,error_1.createError)({statusCode:400,message:"Request body is required"});const{poolId:o,date:i,amount:a,type:s,status:d,currency:c,isClaimed:l=!1}=t;if(!(o&&i&&void 0!==a&&s&&d&&c))throw(0,error_1.createError)({statusCode:400,message:"poolId, date, amount, type, status, and currency are required"});try{null==n||n.step("Check if pool exists");const e=await db_1.models.stakingPool.findByPk(o);if(!e)throw(0,error_1.createError)({statusCode:404,message:"Pool not found"});null==n||n.step("Create admin earning record");const t=await db_1.models.stakingAdminEarning.create({poolId:o,date:i,amount:a,isClaimed:l,type:s,status:d,currency:c,createdAt:new Date});null==n||n.step("Fetch created earning with pool");const u=await db_1.models.stakingAdminEarning.findOne({where:{id:t.id},include:[{model:db_1.models.stakingPool,as:"pool"}]});try{await(0,notifications_1.createNotification)({userId:r.id,relatedId:t.id,type:"system",title:"Admin Earning Added",message:`New admin earning of ${a} ${c} has been added for ${e.name}.`,details:"The earning record has been created successfully.",link:"/admin/staking/earnings",actions:[{label:"View Earnings",link:"/admin/staking/earnings",primary:!0}]},n)}catch(e){console.error("Failed to create notification for admin earning",e)}null==n||n.success("Admin earning created successfully");return u}catch(e){if(404===e.statusCode)throw e;console.error("Error creating admin earning:",e);throw(0,error_1.createError)({statusCode:500,message:e.message})}};