"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Staking Analytics",description:"Retrieves aggregated analytics data for the staking system, including total staked amounts, user counts, and performance metrics.",operationId:"getStakingAnalytics",tags:["Staking","Admin","Analytics"],requiresAuth:!0,logModule:"ADMIN_STAKE",logTitle:"Get Staking Analytics",responses:{200:{description:"Analytics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalStaked:{type:"number"},totalUsers:{type:"number"},totalPools:{type:"number"},stakingByToken:{type:"object",additionalProperties:{type:"number"}},stakingOverTime:{type:"array",items:{type:"object",properties:{date:{type:"string"},amount:{type:"number"}}}},stakedChangePercent:{type:"number"},usersChangePercent:{type:"number"},rewardsChangePercent:{type:"number"},activePoolsCount:{type:"number"},averageAPR:{type:"number"},totalRewardsDistributed:{type:"number"},totalAdminEarnings:{type:"number"},adminEarningsByPool:{type:"object",additionalProperties:{type:"number"}},averageUserROI:{type:"number"},earlyWithdrawalRate:{type:"number"},retentionRate:{type:"number"},poolPerformance:{type:"object",additionalProperties:{type:"object",properties:{apr:{type:"number"},profit:{type:"number"},efficiency:{type:"number"}}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"access.staking"};exports.default=async e=>{const{user:t,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==a||a.step("Fetching data");const e=await db_1.models.stakingPosition.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalStaked"]],where:{status:"ACTIVE"},raw:!0}),t=(null==e?void 0:e.totalStaked)||0,o=await db_1.models.stakingPosition.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("userId"))),"totalUsers"]],raw:!0}),r=(null==o?void 0:o.totalUsers)||0,i=await db_1.models.stakingPool.count({raw:!0})||0,n=await db_1.models.stakingPool.count({where:{status:"ACTIVE"},raw:!0})||0,s=(await db_1.models.stakingPosition.findAll({attributes:[[(0,sequelize_1.col)("pool.token"),"token"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("stakingPosition.amount")),"amount"]],include:[{model:db_1.models.stakingPool,as:"pool",attributes:[]}],where:{status:"ACTIVE"},group:[(0,sequelize_1.col)("pool.token")],raw:!0})).reduce((e,t)=>{e[t.token]=Number.parseFloat(t.amount);return e},{}),l=await db_1.models.stakingEarningRecord.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalRewards"]],raw:!0}),u=(null==l?void 0:l.totalRewards)||0,d=await db_1.models.stakingAdminEarning.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalAdminEarnings"]],where:{isClaimed:!0},raw:!0}),c=(null==d?void 0:d.totalAdminEarnings)||0,p=(await db_1.models.stakingAdminEarning.findAll({attributes:[[(0,sequelize_1.col)("poolId"),"poolId"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"amount"]],where:{isClaimed:!0},group:[(0,sequelize_1.col)("poolId")],raw:!0})).reduce((e,t)=>{e[t.poolId]=Number.parseFloat(t.amount);return e},{}),m=await db_1.models.stakingPool.findOne({attributes:[[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("apr")),"averageAPR"]],where:{status:"ACTIVE"},raw:!0}),g=(null==m?void 0:m.averageAPR)||0,b=t>0?u/t*100:0,_=await db_1.models.stakingExternalPoolPerformance.findAll({attributes:["poolId",[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("apr")),"avgApr"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"totalProfit"]],group:["poolId"],raw:!0}),y=await db_1.models.stakingPool.findAll({attributes:{include:["id","apr",[(0,sequelize_1.literal)("(\n              SELECT COALESCE(SUM(sp.amount), 0)\n              FROM staking_positions AS sp\n              WHERE sp.poolId = stakingPool.id\n            )"),"totalStaked"]]},raw:!0}),f={};y.forEach(e=>{const t=_.find(t=>t.poolId===e.id);if(t){const a=Number.parseFloat(t.avgApr),o=Number.parseFloat(t.totalProfit),r=e.totalStaked*(a/100),i=r>0?o/r:0;f[e.id]={apr:a,profit:o,efficiency:i}}else f[e.id]={apr:e.apr,profit:0,efficiency:0}});const k=new Date;k.setDate(k.getDate()-30);const w=(await db_1.models.stakingPosition.findAll({attributes:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"date"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"amount"]],where:{createdAt:{[sequelize_1.Op.gte]:k}},group:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],order:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"ASC"]],raw:!0})).map(e=>({date:e.date,amount:Number.parseFloat(e.amount)})),A=0,q=0,z=0,P=0,E=0;null==a||a.success("Staking analytics retrieved successfully");return{totalStaked:t,totalUsers:r,totalPools:i,stakingByToken:s,stakingOverTime:w,stakedChangePercent:A,usersChangePercent:q,rewardsChangePercent:z,activePoolsCount:n,averageAPR:g,totalRewardsDistributed:u,totalAdminEarnings:c,adminEarningsByPool:p,averageUserROI:b,earlyWithdrawalRate:P,retentionRate:E,poolPerformance:f}}catch(e){console.error("Error fetching staking analytics:",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch staking analytics"})}};