"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Admin Dashboard Stats",description:"Retrieves comprehensive statistics for the P2P admin dashboard including totals, growth metrics, distributions, and analytics.",operationId:"getAdminP2PDashboardStats",tags:["Admin","Dashboard","P2P"],logModule:"ADMIN_P2P",logTitle:"Get P2P Dashboard Stats",requiresAuth:!0,responses:{200:{description:"Stats retrieved successfully."},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}},permission:"access.p2p"};const calcGrowth=(e,t)=>{if(0===t)return e>0?"+100%":"0%";const a=(e-t)/t*100;return`${a>=0?"+":""}${a.toFixed(1)}%`},getDateRange=e=>{const t=new Date,a=new Date(t);a.setDate(a.getDate()-e);return{start:a,end:t}};exports.default=async e=>{try{const{ctx:t}=e;null==t||t.step("Fetching comprehensive P2P dashboard statistics");const a=new Date,r=new Date(a.getFullYear(),a.getMonth(),a.getDate()),s=new Date(r);s.setDate(s.getDate()-1);const l=new Date(r);l.setDate(l.getDate()-7);const i=new Date(r);i.setDate(i.getDate()-14);const o=new Date(r);o.setMonth(o.getMonth()-1);const d=new Date(r);d.setMonth(d.getMonth()-2);const u=await db_1.models.p2pOffer.count(),n=await db_1.models.p2pOffer.count({where:{createdAt:{[sequelize_1.Op.lt]:r}}}),p=calcGrowth(u,n),c=await db_1.models.p2pOffer.count({where:{status:"ACTIVE"}}),m=await db_1.models.p2pOffer.count({where:{status:"PENDING_APPROVAL"}}),w=await db_1.models.p2pTrade.count({where:{status:{[sequelize_1.Op.in]:["PENDING","PAYMENT_SENT"]}}}),_=await db_1.models.p2pTrade.count({where:{status:{[sequelize_1.Op.in]:["PENDING","PAYMENT_SENT"]},createdAt:{[sequelize_1.Op.between]:[i,l]}}}),b=calcGrowth(w,_),f=await db_1.models.p2pDispute.count({where:{status:{[sequelize_1.Op.in]:["PENDING","IN_PROGRESS"]}}}),h=await db_1.models.p2pDispute.count({where:{status:{[sequelize_1.Op.in]:["PENDING","IN_PROGRESS"]},createdAt:{[sequelize_1.Op.lt]:r}}}),D=calcGrowth(f,h),v=await db_1.models.p2pCommission.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"]],raw:!0}),y=parseFloat((null==v?void 0:v.total)||"0"),O=await db_1.models.p2pCommission.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"]],where:{createdAt:{[sequelize_1.Op.between]:[d,o]}},raw:!0}),q=parseFloat((null==O?void 0:O.total)||"0"),g=calcGrowth(y,q),E=m,N=await db_1.models.p2pOfferFlag.count({where:{isFlagged:!0}}),z=await db_1.models.p2pTrade.count({where:{status:"COMPLETED"}}),A=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"volume"]],where:{status:"COMPLETED"},raw:!0}),P=parseFloat((null==A?void 0:A.volume)||"0"),T=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"volume"]],where:{status:"COMPLETED",createdAt:{[sequelize_1.Op.gte]:l}},raw:!0}),S=parseFloat((null==T?void 0:T.volume)||"0"),C=z>0?P/z:0,M=await db_1.models.p2pOffer.count({where:{type:"BUY",status:"ACTIVE"}}),I=await db_1.models.p2pOffer.count({where:{type:"SELL",status:"ACTIVE"}}),G=await db_1.models.p2pOffer.findAll({attributes:["status",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["status"],raw:!0}),V=await db_1.models.p2pOffer.findAll({attributes:["currency",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],where:{status:"ACTIVE"},group:["currency"],order:[[(0,sequelize_1.literal)("count"),"DESC"]],limit:10,raw:!0}),F=await db_1.models.p2pPaymentMethod.findAll({attributes:["id","name","icon","popularityRank"],where:{available:!0},order:[["popularityRank","ASC"]],limit:5,raw:!0}),U=await db_1.models.p2pDispute.count({where:{status:"RESOLVED"}}),R=await db_1.models.p2pDispute.count({where:{status:{[sequelize_1.Op.in]:["PENDING","IN_PROGRESS"]},priority:"HIGH"}}),L=await db_1.models.p2pTrade.findAll({attributes:["sellerId",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("p2pTrade.id")),"tradeCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"totalVolume"]],where:{status:"COMPLETED"},include:[{model:db_1.models.user,as:"seller",attributes:["id","firstName","lastName","email","avatar"]}],group:["sellerId","seller.id"],order:[[(0,sequelize_1.literal)("totalVolume"),"DESC"]],limit:5,raw:!1}),$=[];for(let e=6;e>=0;e--){const t=new Date(r);t.setDate(t.getDate()-e);const a=new Date(t);a.setDate(a.getDate()+1);const s=await db_1.models.p2pTrade.count({where:{status:"COMPLETED",createdAt:{[sequelize_1.Op.between]:[t,a]}}}),l=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"volume"]],where:{status:"COMPLETED",createdAt:{[sequelize_1.Op.between]:[t,a]}},raw:!0}),i=await db_1.models.p2pCommission.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"revenue"]],where:{createdAt:{[sequelize_1.Op.between]:[t,a]}},raw:!0});$.push({date:t.toLocaleDateString("en-US",{month:"short",day:"numeric"}),trades:s,volume:parseFloat((null==l?void 0:l.volume)||"0"),revenue:parseFloat((null==i?void 0:i.revenue)||"0")})}const x=await db_1.models.p2pTrade.findAll({attributes:["id","type","currency","amount","total","status","createdAt"],include:[{model:db_1.models.user,as:"buyer",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.user,as:"seller",attributes:["id","firstName","lastName","avatar"]}],order:[["createdAt","DESC"]],limit:5,raw:!1}),B=await db_1.models.p2pDispute.findAll({attributes:["id","reason","status","priority","createdAt"],include:[{model:db_1.models.user,as:"reportedBy",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.p2pTrade,as:"trade",attributes:["id","currency","total"]}],order:[["createdAt","DESC"]],limit:5,raw:!1}),Y=z>0?f/z*100:0,k=u>0?E/u*100:0;let H=100;Y>5?H-=20:Y>2&&(H-=10);R>5?H-=15:R>2&&(H-=5);k>20?H-=10:k>10&&(H-=5);N>10?H-=10:N>5&&(H-=5);const j=H>=90?"Excellent":H>=70?"Good":H>=50?"Fair":"Needs Attention";null==t||t.success("P2P dashboard statistics retrieved successfully");return{totalOffers:u,offerGrowth:p,activeOffers:c,pendingOffers:m,activeTrades:w,tradeGrowth:b,openDisputes:f,disputeChange:D,platformRevenue:`$${y.toLocaleString("en-US",{minimumFractionDigits:2,maximumFractionDigits:2})}`,revenueGrowth:g,pendingVerifications:E,flaggedOffers:N,systemHealth:j,healthScore:H,completedTrades:z,totalVolume:P,weekVolume:S,avgTradeValue:C,offerTypeDist:{buy:M,sell:I},offerStatusDist:G.map(e=>({status:e.status,count:parseInt(e.count)})),currencyDist:V.map(e=>({currency:e.currency,count:parseInt(e.count)})),paymentMethods:F,disputeStats:{open:f,resolved:U,highPriority:R},topTraders:L.map(e=>{var t,a,r,s,l,i;return{id:null===(t=e.seller)||void 0===t?void 0:t.id,name:`${(null===(a=e.seller)||void 0===a?void 0:a.firstName)||""} ${(null===(r=e.seller)||void 0===r?void 0:r.lastName)||""}`.trim(),avatar:null===(s=e.seller)||void 0===s?void 0:s.avatar,tradeCount:parseInt((null===(l=e.dataValues)||void 0===l?void 0:l.tradeCount)||e.tradeCount||"0"),totalVolume:parseFloat((null===(i=e.dataValues)||void 0===i?void 0:i.totalVolume)||e.totalVolume||"0")}}),tradeTimeline:$,recentTrades:x.map(e=>({id:e.id,type:e.type,currency:e.currency,amount:e.amount,total:e.total,status:e.status,createdAt:e.createdAt,buyer:e.buyer?{id:e.buyer.id,name:`${e.buyer.firstName||""} ${e.buyer.lastName||""}`.trim(),avatar:e.buyer.avatar}:null,seller:e.seller?{id:e.seller.id,name:`${e.seller.firstName||""} ${e.seller.lastName||""}`.trim(),avatar:e.seller.avatar}:null})),recentDisputes:B.map(e=>({id:e.id,reason:e.reason,status:e.status,priority:e.priority,createdAt:e.createdAt,reportedBy:e.reportedBy?{id:e.reportedBy.id,name:`${e.reportedBy.firstName||""} ${e.reportedBy.lastName||""}`.trim(),avatar:e.reportedBy.avatar}:null,trade:e.trade?{id:e.trade.id,currency:e.trade.currency,total:e.trade.total}:null}))}}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};