"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk delete Mailwizard templates",operationId:"bulkDeleteMailwizardTemplates",tags:["Admin","Mailwizard","Templates"],description:"Permanently deletes multiple Mailwizard templates by their IDs. This operation cannot be undone. Templates that are currently in use by active campaigns cannot be deleted.",parameters:(0,query_1.commonBulkDeleteParams)("Mailwizard Templates"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of Mailwizard template IDs to delete"}},required:["ids"]}}}},responses:(0,errors_1.bulkDeleteResponses)("Mailwizard Template"),requiresAuth:!0,permission:"delete.mailwizard.template",logModule:"ADMIN_MAIL",logTitle:"Bulk delete templates"};exports.default=async e=>{const{body:t,query:a,ctx:r}=e,{ids:l}=t;null==r||r.step(`Deleting ${l.length} templates`);const s=await(0,query_1.handleBulkDelete)({model:"mailwizardTemplate",ids:l,query:a});null==r||r.success(`${l.length} templates deleted successfully`);return s};