"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk update campaign status",operationId:"bulkUpdateMailwizardCampaignStatus",tags:["Admin","Mailwizard","Campaigns"],description:"Updates the status of multiple Mailwizard campaigns simultaneously. Valid statuses: PENDING, PAUSED, ACTIVE, STOPPED, COMPLETED, CANCELLED. This allows for efficient batch status changes across multiple campaigns.",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of Mailwizard Campaign IDs to update",items:{type:"string"}},status:{type:"string",enum:["PENDING","PAUSED","ACTIVE","STOPPED","COMPLETED","CANCELLED"],description:"New status to apply to the Mailwizard Campaigns"}},required:["ids","status"]}}}},responses:(0,errors_1.statusUpdateResponses)("Mailwizard Campaign"),requiresAuth:!0,permission:"edit.mailwizard.campaign",logModule:"ADMIN_MAIL",logTitle:"Bulk update campaign status"};exports.default=async a=>{const{body:t,ctx:s}=a,{ids:e,status:i}=t;null==s||s.step(`Updating status of ${e.length} campaigns to ${i}`);const r=await(0,query_1.updateStatus)("mailwizardCampaign",e,i);null==s||s.success(`${e.length} campaigns status updated successfully`);return r};