"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists ICO transactions with optional filters",operationId:"listIcoTransactions",tags:["Admin","Ico","Transaction"],parameters:constants_1.crudParameters,responses:{401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transactions"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_ICO",logTitle:"Get ICO Transactions",permission:"view.ico.transaction",demoMask:["items.user.email"]};exports.default=async e=>{const{user:r,query:s,ctx:t}=e;null==t||t.step("Validate user authentication");if(!r)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==t||t.success("Get ICO Transactions retrieved successfully");return(0,query_1.getFiltered)({model:db_1.models.icoTransaction,query:s,sortField:s.sortField||"createdAt",includeModels:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["id","name","symbol","tokenPrice","targetAmount"]},{model:db_1.models.user,as:"user",attributes:["id","email","firstName","lastName","avatar"]}]})};