"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create ICO Token Type",description:"Creates a new token type configuration for ICO offerings. Token types define the category of tokens (e.g., ERC-20, BEP-20, utility, security).",operationId:"createIcoTokenType",tags:["Admin","ICO","Settings"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"The display name of the token type"},value:{type:"string",description:"The unique value identifier for the token type"},description:{type:"string",description:"A description of the token type"},status:{type:"boolean",description:"Status flag. Defaults to true if not provided"}},required:["name","value","description"]}}}},responses:{200:{description:"Token type configuration created successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},tokenType:{type:"object",description:"The created token type"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"edit.ico.settings",logModule:"ADMIN_ICO",logTitle:"Create token type"};exports.default=async e=>{const{user:t,body:r,ctx:s}=e;null==s||s.step("Validating user permissions");if(!(null==t?void 0:t.id)){null==s||s.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{name:o,value:i,description:n,status:a}=r;null==s||s.step("Validating token type data");if(!o||!i||!n){null==s||s.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: name, value and description"})}const p=void 0===a||a;null==s||s.step("Creating token type");const u=await db_1.models.icoTokenType.create({name:o,value:i,description:n,status:p});null==s||s.success("Token type created successfully");return{message:"Token type configuration created successfully.",tokenType:u}};