"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List ICO Token Types",description:"Retrieves all token type configurations for ICO offerings. Supports optional filtering by status to retrieve only active token types.",operationId:"getIcoTokenTypes",tags:["Admin","ICO","Settings"],requiresAuth:!0,parameters:[{name:"status",in:"query",description:"Filter by status - set to 'true' to retrieve only active token types",required:!1,schema:{type:"string",enum:["true","false"]}}],responses:{200:{description:"Token type configurations retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid"},name:{type:"string",description:"Display name of the token type"},value:{type:"string",description:"Unique identifier value for the token type"},description:{type:"string",description:"Description of the token type"},status:{type:"boolean",description:"Whether the token type is active"},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"},deletedAt:{type:"string",format:"date-time",nullable:!0}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.ico.settings",logModule:"ADMIN_ICO",logTitle:"Get token types"};exports.default=async e=>{const{user:t,query:r,ctx:s}=e;null==s||s.step("Validating user permissions");if(!(null==t?void 0:t.id)){null==s||s.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: Admin privileges required."})}null==s||s.step("Building query filters");const i="true"===(null==r?void 0:r.status)?{status:!0}:{};null==s||s.step("Fetching token types");const o=await db_1.models.icoTokenType.findAll({where:i});null==s||s.success(`Retrieved ${o.length} token types`);return o};