"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Reorder ICO Launch Plans",description:"Bulk updates the sort order for launch plans. Accepts an array of objects with plan IDs and their new sortOrder values to reposition plans in the display sequence.",operationId:"reorderIcoLaunchPlans",tags:["Admin","ICO","Settings"],requestBody:{description:"Array of launch plans with new sortOrder values",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},sortOrder:{type:"number"}},required:["id","sortOrder"]}}}}},responses:{200:{description:"Launch plans reordered successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.ico.settings",logModule:"ADMIN_ICO",logTitle:"Reorder launch plans"};exports.default=async e=>{const{body:r,ctx:s}=e;null==s||s.step("Validating request body");if(!Array.isArray(r)){null==s||s.fail("Invalid request body format");throw(0,error_1.createError)({statusCode:400,message:"Request body must be an array of launch plans"})}null==s||s.step(`Reordering ${r.length} launch plans`);const t=r.map(e=>e.id&&"number"==typeof e.sortOrder?(0,query_1.updateRecord)("icoLaunchPlan",e.id,{sortOrder:e.sortOrder}):Promise.resolve());await Promise.all(t);null==s||s.success("Launch plans reordered successfully");return{message:"Launch plans reordered successfully"}};