"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants");exports.metadata={summary:"List gateway merchants",description:"Retrieves a paginated list of all gateway merchant accounts with filtering and sorting capabilities. Includes user information for each merchant.",operationId:"listGatewayMerchants",tags:["Admin","Gateway","Merchant"],parameters:constants_1.crudParameters,responses:{200:{description:"Paginated list of merchants",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",description:"Gateway merchant with associated user information"}},pagination:{type:"object",properties:{total:{type:"number"},page:{type:"number"},perPage:{type:"number"}}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.gateway.merchant",demoMask:["items.user.email","items.email","items.phone"],logModule:"ADMIN_GATEWAY",logTitle:"List gateway merchants"};exports.default=async e=>{var t;const{query:a,ctx:s}=e;null==s||s.step("Fetching merchants list");const r=await(0,query_1.getFiltered)({model:db_1.models.gatewayMerchant,query:a,sortField:a.sortField||"createdAt",includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]});null==s||s.success(`Retrieved ${(null===(t=r.items)||void 0===t?void 0:t.length)||0} merchants`);return r};