"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),cache_1=require("@b/utils/cache"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List available gateway currencies",description:"Retrieves available wallet types (FIAT, SPOT, ECO) and their supported currencies for gateway payment configuration. Returns currencies filtered by enabled wallet types in system settings.",operationId:"listGatewayCurrencies",tags:["Admin","Gateway","Currencies"],responses:{200:{description:"Available wallet types and currencies",content:{"application/json":{schema:{type:"object",properties:{walletTypes:{type:"array",items:{type:"object",properties:{value:{type:"string",description:"Wallet type code (FIAT, SPOT, ECO)"},label:{type:"string",description:"Display label"},enabled:{type:"boolean",description:"Whether this wallet type is enabled"},currencies:{type:"array",items:{type:"object",properties:{value:{type:"string",description:"Currency code"},label:{type:"string",description:"Currency display label"},icon:{type:"string",description:"Currency icon/symbol"}}}}}}},systemSettings:{type:"object",properties:{kycEnabled:{type:"boolean",description:"Whether KYC is enabled"}}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.gateway.settings",logModule:"ADMIN_GATEWAY",logTitle:"Get gateway currencies"};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching system configuration");const r=cache_1.CacheManager.getInstance(),s=await r.getExtensions(),a=await r.getSetting("spotWallets"),n=await r.getSetting("fiatWallets"),i=!0===a||"true"===a,c=!0===n||"true"===n,l=s.has("ecosystem");null==t||t.step("Loading available currencies by wallet type");const o=[];if(c){const e=await db_1.models.currency.findAll({where:{status:!0},attributes:["id","name","symbol"],order:[["id","ASC"]]});o.push({value:"FIAT",label:"Fiat",enabled:!0,currencies:e.map(e=>({value:e.id,label:`${e.id} - ${e.name}`,icon:e.symbol}))})}if(i){const e=await db_1.models.exchangeCurrency.findAll({where:{status:!0},attributes:["currency","name"],order:[["currency","ASC"]]});o.push({value:"SPOT",label:"Spot",enabled:!0,currencies:e.map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`}))})}if(l){const e=await db_1.models.ecosystemToken.findAll({where:{status:!0},attributes:["currency","name","icon"],order:[["currency","ASC"]]}),t=new Set,r=e.filter(e=>{const r=t.has(e.currency);t.add(e.currency);return!r});o.push({value:"ECO",label:"Ecosystem",enabled:!0,currencies:r.map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`,icon:e.icon}))})}const u=await r.getSetting("kycStatus");null==t||t.success(`Retrieved ${o.length} wallet types with currencies`);return{walletTypes:o,systemSettings:{kycEnabled:!0===u||"true"===u}}};