"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const constants_1=require("@b/utils/constants"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");let getFiltered;try{const e=require("@b/api/(ext)/ecosystem/utils/scylla/query");getFiltered=e.getFiltered}catch(e){}exports.metadata={summary:"Lists all futures orders with pagination and filtering",operationId:"listFuturesOrders",tags:["Admin","Futures","Order"],description:"Retrieves a paginated list of all futures orders from ScyllaDB with support for filtering, sorting, and search. Returns order details including type, status, side, price, amount, fees, and associated user information.",parameters:constants_1.crudParameters,responses:{200:{description:"Futures orders retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.orderSchema}},pagination:constants_1.paginationSchema}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Futures Orders"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.futures.order",logModule:"ADMIN_FUTURES",logTitle:"List futures orders"};const keyspace=process.env.SCYLLA_FUTURES_KEYSPACE||"futures";exports.default=async e=>{const{query:r,ctx:t}=e;if(!getFiltered)return{error:"Ecosystem extension not available",status:500};null==t||t.step("Fetching futures orders");const s=await getFiltered({table:"orders",query:r,filter:r.filter,sortField:r.sortField||"createdAt",sortOrder:r.sortOrder||"DESC",perPage:Number(r.perPage)||10,allowFiltering:!0,keyspace:keyspace,partitionKeys:["userId"],transformColumns:["amount","cost","fee","filled","price","remaining","leverage","stopLossPrice","takeProfitPrice"],nonStringLikeColumns:["userId"]});null==t||t.success(`Retrieved ${s.items.length} futures orders`);return s};