"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),order_1=require("@b/api/(ext)/futures/utils/queries/order"),query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error");exports.metadata={summary:"Bulk deletes futures markets by IDs",operationId:"bulkDeleteFuturesMarkets",tags:["Admin","Futures","Market"],description:"Permanently deletes multiple futures markets and all associated data including orders and positions. This operation cannot be undone.",parameters:(0,query_1.commonBulkDeleteParams)("Futures Markets"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of futures market IDs to delete"}},required:["ids"]}}}},responses:{200:{description:"Futures markets deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Futures Markets"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"delete.futures.market",logModule:"ADMIN_FUTURES",logTitle:"Bulk delete futures markets"};exports.default=async e=>{const{body:r,query:t,ctx:s}=e,{ids:u}=r;null==s||s.step("Fetching markets to delete");const o=await db_1.models.futuresMarket.findAll({where:{id:u},attributes:["currency"]});if(!o.length){null==s||s.fail("Markets not found");throw(0,error_1.createError)({statusCode:404,message:"Markets not found"})}const a=async()=>{null==s||s.step("Cleaning up market data");for(const e of o)await(0,order_1.deleteAllMarketData)(e.currency)};try{null==s||s.step("Performing bulk delete");const e=await(0,query_1.handleBulkDelete)({model:"futuresMarket",ids:u,query:{...t,force:!0},postDelete:a});null==s||s.success(`Successfully deleted ${u.length} futures markets`);return e}catch(e){null==s||s.fail(`Failed to delete futures markets: ${e.message}`);throw e}};