"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk deletes Forex plans",description:"Deletes multiple Forex plan configurations by their IDs. This will cascade delete to associated plan durations and investments.",operationId:"bulkDeleteForexPlans",tags:["Admin","Forex","Plan"],parameters:(0,query_1.commonBulkDeleteParams)("Forex Plans"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of Forex plan IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("Forex Plans"),requiresAuth:!0,permission:"delete.forex.plan",logModule:"ADMIN_FOREX",logTitle:"Bulk delete forex plans"};exports.default=async e=>{const{body:t,query:s,ctx:l}=e,{ids:r}=t;null==l||l.step(`Validating ${r.length} forex plan IDs`);null==l||l.step(`Deleting ${r.length} forex plans`);const o=await(0,query_1.handleBulkDelete)({model:"forexPlan",ids:r,query:s});null==l||l.success(`Successfully deleted ${r.length} forex plans`);return o};