"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk deletes Forex investments",description:"Deletes multiple Forex investment records by their IDs. This permanently removes investment data and cannot be undone.",operationId:"bulkDeleteForexInvestments",tags:["Admin","Forex","Investment"],parameters:(0,query_1.commonBulkDeleteParams)("Forex Investments"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of Forex investment IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("Forex Investments"),requiresAuth:!0,permission:"delete.forex.investment",logModule:"ADMIN_FOREX",logTitle:"Bulk delete forex investments"};exports.default=async e=>{const{body:t,query:s,ctx:n}=e,{ids:r}=t;null==n||n.step(`Validating ${r.length} forex investment IDs`);null==n||n.step(`Deleting ${r.length} forex investments`);const o=await(0,query_1.handleBulkDelete)({model:"forexInvestment",ids:r,query:s});null==n||n.success(`Successfully deleted ${r.length} forex investments`);return o};