"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Lists all Forex durations",description:"Retrieves a paginated list of all Forex durations with optional filtering and sorting. Durations define the time periods available for Forex investments.",operationId:"listForexDurations",tags:["Admin","Forex","Duration"],parameters:constants_1.crudParameters,logModule:"ADMIN_FOREX",logTitle:"Get Forex Durations",responses:{200:{description:"List of Forex Durations with pagination information",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.forexDurationSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Durations"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.forex.duration"};exports.default=async e=>{var t;const{query:r,ctx:o}=e;null==o||o.step("Fetching forex durations");const i=await(0,query_1.getFiltered)({model:db_1.models.forexDuration,query:r,sortField:r.sortField||"duration",timestamps:!1,numericFields:["duration"]});null==o||o.success(`Retrieved ${(null===(t=i.items)||void 0===t?void 0:t.length)||0} forex durations`);return i};