"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk deletes Forex accounts",operationId:"bulkDeleteForexAccounts",tags:["Admin","Forex","Account"],description:"Deletes multiple Forex accounts by their IDs. This operation permanently removes the accounts from the system.",parameters:(0,query_1.commonBulkDeleteParams)("Forex Accounts"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of Forex account IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("Forex Accounts"),requiresAuth:!0,permission:"delete.forex.account",logModule:"ADMIN_FOREX",logTitle:"Bulk delete forex accounts"};exports.default=async e=>{const{body:t,query:o,ctx:s}=e,{ids:r}=t;null==s||s.step(`Validating ${r.length} forex account IDs`);null==s||s.step(`Deleting ${r.length} forex accounts`);const u=await(0,query_1.handleBulkDelete)({model:"forexAccount",ids:r,query:o});null==s||s.success(`Successfully deleted ${r.length} forex accounts`);return u};