"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Reorder FAQs",description:"Reorders FAQ entries within a page or moves a FAQ to a different page. Updates the order field for all affected FAQs. Supports drag-and-drop functionality.",operationId:"reorderFaqs",tags:["Admin","FAQ","Reorder"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{faqId:{type:"string",format:"uuid",description:"ID of the FAQ being moved"},targetId:{type:["string","null"],format:"uuid",description:"ID of the FAQ at the target position (null if dropping to empty area)"},targetPagePath:{type:"string",description:"Optional new page path if moving to a different page"}},required:["faqId"]}}}},responses:{200:(0,errors_1.successMessageResponse)("FAQs reordered successfully"),400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("FAQ"),500:errors_1.serverErrorResponse},permission:"edit.faq",logModule:"ADMIN_FAQ",logTitle:"Reorder FAQs"};exports.default=async e=>{const{user:r,body:t,ctx:o}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{faqId:s,targetId:a,targetPagePath:i}=t;if(!s){null==o||o.fail("Missing faqId");throw(0,error_1.createError)({statusCode:400,message:"Missing faqId"})}null==o||o.step("Fetching dragged FAQ");const d=await db_1.models.faq.findByPk(s);if(!d){null==o||o.fail("Dragged FAQ not found");throw(0,error_1.createError)({statusCode:404,message:"Dragged FAQ not found"})}let n=null;if(a){null==o||o.step("Fetching target FAQ");n=await db_1.models.faq.findByPk(a);if(!n){null==o||o.fail("Target FAQ not found");throw(0,error_1.createError)({statusCode:404,message:"Target FAQ not found"})}}const l=i||d.pagePath,u=await db_1.sequelize.transaction();try{null==o||o.step("Reordering FAQs");const e=(await db_1.models.faq.findAll({where:{pagePath:l},order:[["order","ASC"]],transaction:u})).filter(e=>e.id!==d.id);let r=e.length;if(n){const t=e.findIndex(e=>e.id===n.id);if(-1===t){null==o||o.fail("Target FAQ not found in destination page");throw(0,error_1.createError)({statusCode:404,message:"Target FAQ not found in the destination page"})}r=t}e.splice(r,0,d);null==o||o.step("Updating FAQ order");for(let r=0;r<e.length;r++)await e[r].update({order:r,pagePath:l},{transaction:u});await u.commit();null==o||o.success("FAQs reordered successfully");return{message:"FAQs reordered successfully"}}catch(e){await u.rollback();null==o||o.fail("Failed to reorder FAQs");throw(0,error_1.createError)({statusCode:500,message:"Failed to reorder FAQs"})}};