"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get User-Submitted FAQ Questions",description:"Retrieves all user-submitted FAQ questions for admin review. Returns questions ordered by creation date (newest first).",operationId:"getFaqQuestions",tags:["Admin","FAQ","Questions"],requiresAuth:!0,responses:{200:{description:"FAQ questions retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid"},name:{type:"string",description:"Submitter name"},email:{type:"string",format:"email"},question:{type:"string"},answer:{type:"string",nullable:!0},status:{type:"string",enum:["PENDING","ANSWERED","REJECTED"]},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.faq.question",logModule:"ADMIN_FAQ",logTitle:"Get FAQ questions"};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==r||r.step("Fetching faq questions");const e=await db_1.models.faqQuestion.findAll({order:[["createdAt","DESC"]]});null==r||r.success("FAQ questions retrieved successfully");return e}catch(e){console.error("Error fetching FAQ questions:",e);null==r||r.fail("Failed to fetch faq questions");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to fetch FAQ questions"})}};