"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get FAQs with Filters",description:"Retrieves FAQs with pagination and filtering options. Supports searching by question/answer text, filtering by category, status, and page path. Returns paginated results sorted by order.",operationId:"getAdminFaqs",tags:["Admin","FAQ","Pagination"],requiresAuth:!0,parameters:[{index:0,name:"page",in:"query",required:!1,schema:{type:"number"},description:"Page number for pagination (default: 1)"},{index:1,name:"limit",in:"query",required:!1,schema:{type:"number"},description:"Number of items per page (default: 10)"},{index:2,name:"search",in:"query",required:!1,schema:{type:"string"},description:"Search query for FAQ question or answer"},{index:3,name:"category",in:"query",required:!1,schema:{type:"string"},description:"Filter by FAQ category"},{index:4,name:"status",in:"query",required:!1,schema:{type:"string",enum:["active","inactive","all"]},description:"Filter by FAQ status: active, inactive, or all"},{index:5,name:"pagePath",in:"query",required:!1,schema:{type:"string"},description:"Filter by page path"}],responses:{200:{description:"FAQs retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"},description:"Array of FAQ items"},pagination:errors_1.paginationSchema}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.faq",logModule:"ADMIN_FAQ",logTitle:"Get FAQs for admin"};exports.default=async e=>{const{user:r,query:t,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const i={};if(t.search){const e=t.search.toLowerCase();i[sequelize_1.Op.or]=[{question:{[sequelize_1.Op.like]:`%${e}%`}},{answer:{[sequelize_1.Op.like]:`%${e}%`}}]}t.category&&(i.category=t.category);t.status&&"all"!==t.status&&(i.status="active"===t.status);t.pagePath&&(i.pagePath=t.pagePath);const a=parseInt(t.page,10)||1,n=parseInt(t.limit,10)||10,o=(a-1)*n;null==s||s.step("Fetching FAQs with filters");const{count:u,rows:p}=await db_1.models.faq.findAndCountAll({where:i,order:[["order","ASC"]],offset:o,limit:n});null==s||s.success("FAQs retrieved successfully");return{items:p,pagination:{currentPage:a,totalPages:Math.ceil(u/n),totalItems:u,perPage:n}}};