"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk Delete FAQs",description:"Deletes multiple FAQ entries in a single operation. Accepts an array of FAQ IDs to delete.",operationId:"bulkDeleteFaqs",tags:["Admin","FAQ","BulkOperations"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string",format:"uuid"},description:"Array of FAQ IDs to delete"}},required:["ids"]}}}},responses:{200:(0,errors_1.successMessageResponse)("FAQs deleted successfully"),400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"delete.faq",logModule:"ADMIN_FAQ",logTitle:"Bulk delete FAQs"};exports.default=async e=>{const{user:r,body:s,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{ids:o}=s;if(!Array.isArray(o)||0===o.length){null==t||t.fail("No FAQ IDs provided");throw(0,error_1.createError)({statusCode:400,message:"No FAQ IDs provided"})}null==t||t.step("Deleting FAQs");await db_1.models.faq.destroy({where:{id:o}});null==t||t.success("FAQs deleted successfully");return{message:"FAQs deleted successfully"}};