"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const deepseek_client_1=require("@b/utils/ai/deepseek-client"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Summarize FAQ Content with AI",description:"Generates a concise summary of the provided FAQ content using AI. Useful for creating brief descriptions or meta descriptions from longer FAQ answers.",operationId:"summarizeFaqContentWithAi",tags:["Admin","FAQ","AI"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{content:{type:"string",description:"FAQ content to summarize"}},required:["content"]}}}},responses:{200:{description:"Content summarized successfully",content:{"application/json":{schema:{type:"object",properties:{summary:{type:"string",description:"AI-generated summary of the content"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"create.faq",logModule:"ADMIN_FAQ",logTitle:"AI summarize content"};exports.default=async e=>{const{user:r,body:t,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{content:o}=t;if(!o){null==s||s.fail("Content is required");throw(0,error_1.createError)({statusCode:400,message:"Content is required"})}try{null==s||s.step("Summarizing content with AI");const e=await deepseek_client_1.deepseekClient.summarizeFAQ(o);null==s||s.success("Content summarized successfully");return e}catch(e){null==s||s.fail("Failed to summarize content");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to summarize content"})}};