"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const deepseek_client_1=require("@b/utils/ai/deepseek-client"),db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Generate AI Answer for User Question",description:"Uses AI to generate an answer to a user question based on existing active FAQs. The AI analyzes all active FAQ entries to provide a relevant answer.",operationId:"generateAiAnswerForQuestion",tags:["Admin","FAQ","AI"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{question:{type:"string",description:"The user question to be answered"}},required:["question"]}}}},responses:{200:{description:"AI-generated answer returned successfully",content:{"application/json":{schema:{type:"object",properties:{answer:{type:"string",description:"AI-generated answer based on existing FAQs"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"create.faq",logModule:"ADMIN_FAQ",logTitle:"AI answer question"};exports.default=async e=>{const{user:r,body:s,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{question:n}=s;if(!n){null==t||t.fail("Question is required");throw(0,error_1.createError)({statusCode:400,message:"Question is required"})}try{null==t||t.step("Retrieving active FAQs");const e=await db_1.models.faq.findAll({where:{status:!0},attributes:["question","answer"],raw:!0});null==t||t.step("Generating AI answer");const r=await deepseek_client_1.deepseekClient.answerQuestion(n,e);null==t||t.success("Question answered successfully");return r}catch(e){null==t||t.fail("Failed to answer question");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to answer question"})}};