"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"List all ecosystem master wallets",description:"Retrieves a paginated list of ecosystem master wallets with optional filtering and sorting. Includes real-time balance updates fetched from the blockchain, associated custodial wallets, and full wallet configuration details.",operationId:"listEcosystemMasterWallets",tags:["Admin","Ecosystem","Wallet"],parameters:constants_1.crudParameters,responses:{200:{description:"Master wallets retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.ecosystemMasterWalletSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Ecosystem Master Wallets"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.ecosystem.master.wallet",demoMask:["items.address","items.ecosystemCustodialWallets.address"]};exports.default=async e=>{const{query:t,ctx:s}=e;null==s||s.step("Fetching master wallets list with balances");const a=await(0,query_1.getFiltered)({model:db_1.models.ecosystemMasterWallet,query:t,sortField:t.sortField||"chain",timestamps:!1,includeModels:[{model:db_1.models.ecosystemCustodialWallet,as:"ecosystemCustodialWallets",attributes:["id","address","status"]}]});if(a.items&&a.items.length>0){const e=a.items.map(async(e,t)=>{const s=new Promise((e,t)=>setTimeout(()=>t(new Error("Balance fetch timeout")),5e3)),a=(async()=>{var s;try{const t="function"==typeof e.get?e.get({plain:!0}):e;await(0,utils_1.getEcosystemMasterWalletBalance)(t);const s=await db_1.models.ecosystemMasterWallet.findByPk(t.id,{attributes:["id","chain","currency","address","balance","status","lastIndex"],raw:!0});s&&("function"==typeof e.get?e.set("balance",s.balance):e.balance=s.balance)}catch(e){console.log(`Balance update failed for wallet ${t}: ${null===(s=null==e?void 0:e.message)||void 0===s?void 0:s.substring(0,50)}`)}})();return Promise.race([a,s]).catch(e=>{console.log(`Wallet ${t} update timeout or error: ${e.message}`)})}),t=new Promise(e=>setTimeout(e,1e4));await Promise.race([Promise.allSettled(e),t])}null==s||s.success("Retrieved master wallets successfully");return a};