"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Get available master wallets for custodial wallet creation",description:"Retrieves a list of master wallets that support custodial wallet creation. Excludes chains that do not support smart contract deployment (SOL, TRON, BTC, LTC, DOGE, DASH, XMR, TON, MO).",operationId:"getEcosystemCustodialWalletOptions",tags:["Admin","Ecosystem","Wallet"],requiresAuth:!0,responses:{200:{description:"Ecosystem custodial wallet options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{value:{type:"string"},label:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("EcosystemMasterWallet"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)(401,"Unauthorized");null==r||r.step("Fetching custodial wallet options");try{const e=(await db_1.models.ecosystemMasterWallet.findAll({where:{chain:{[sequelize_1.Op.notIn]:["SOL","TRON","BTC","LTC","DOGE","DASH","XMR","TON","MO"]}}})).map(e=>({value:e.id,label:`${e.chain} - ${e.address.substring(0,10)}...`}));null==r||r.success(`Retrieved ${e.length} custodial wallet options`);return e}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching ecosystem custodial wallet options")}};