"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk update ecosystem UTXO status",operationId:"bulkUpdateEcosystemUtxoStatus",tags:["Admin","Ecosystem","UTXO"],description:"Bulk updates the operational status of multiple ecosystem UTXOs. This endpoint allows administrators to activate or deactivate multiple UTXOs simultaneously by providing an array of UTXO IDs and the desired status. Useful for managing UTXO availability across the ecosystem.",logModule:"ADMIN_ECO",logTitle:"Bulk update UTXO status",requestBody:{required:!0,description:"Array of UTXO IDs and the new status to apply (true for active/available, false for inactive/spent)",content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of ecosystem UTXO IDs to update",items:{type:"string"}},status:{type:"boolean",description:"New operational status (true for active/available, false for inactive/spent)"}},required:["ids","status"]}}}},responses:(0,query_1.updateRecordResponses)("Ecosystem UTXO"),requiresAuth:!0,permission:"edit.ecosystem.utxo"};exports.default=async t=>{const{body:e,ctx:s}=t,{ids:a,status:o}=e;null==s||s.step(`Updating status for ${a.length} UTXO(s) to ${o}`);const r=await(0,query_1.updateStatus)("ecosystemUtxo",a,o);null==s||s.success(`Status updated for ${a.length} UTXO(s)`);return r};